function [x, residual] = uqrlstsq(A,b)
%uqrlstsq Solve the m x n full rank underdetermined least-squares problem.
%
%   x = uqrlstsq(A,b) solves the full rank underdetermined least-squares
%   problem using the QR decomposition. A is an m x n matrix, m < n, and
%   b is an m x 1 vector. The n x 1 vector x is the minimum norm solution.

[m, n] = size(A);
[Q, R] = hqr(A');
R1 = R(1:m,1:m);
y = forsolve(R1',b);
x = Q(1:n,1:m)*y(1:m);
residual = norm(b-A*x);
