function V = vandermonde(x, m)
%vandermonde Compute the Vandermonde matrix.
%
%   V = vandermonde(x,m) forms the Vandermonde matrix for a polynomial
%   of degree m with the x-axis data in vector x. V is an n x (m+1) matrix,
%   with powers of x-components in columns 2 through (m+1).

n = length(x);
V = ones(n, m+1);
y = x;
for i = 2:m+1
   V(:,i) = y;
   y = y.*x;
end
