function w = wilkpoly(perturbation)
% WILKPOLY Build the 20th degree Wilkinson polynomial
% p(x) = (x-20)(x-19)...(x-2)(x-1)
%
%INPUT: perturbation is a small number that will be added
%       to p_{19}

w = [1 -1];
for i = 2:20
   factor = [1 -i];
   w = conv(w,factor);
end

if nargin == 1
   w(2) = w(2) + perturbation;
end
	