function kubicky_spline(x,f,Da,Db)
%
% Sestroji kubicky spline 
% pro funkci zadanou tabulkou [x;f(x)]
%
% nejsou-li zadane vektory x,f => zadaji se mysi
% Da, Db ... podminky pro derivace v krajnich bodech

clc;
pocet_deleni=1000;
presah=15;

figure(1);
clf;
hold on;
zoom on;
set(figure(1),'Units','centimeters');
set(figure(1),'Position',[10 3 18 15]);

if ~exist('x') || ~exist('f')
  [x,f]=zadej_body;
  clc;
else
  xmin=min(x);
  xmax=max(x);
  fmin=min(f);
  fmax=max(f);
  plot(x,f,'ro');
end  

[x,indexy]=sort(x);
f=f(indexy);
n=max(size(x));
deleni=(x(n)-x(1))/pocet_deleni;
zoom on;

disp('----------------------------------------------------------------');
fprintf('  Kubicky spline pro funkci danou tabulkou\n');
disp(' ');
fprintf(' |    x(k)    |    f(k)    |\n');
fprintf(' ===========================\n');
for i=1:n
  fprintf(' | %9.4f  | %9.4f  |\n',x(i),f(i));
end  

if exist('Da')~=1 || exist('Db')~=1    
  disp(' ');
  fprintf('Zadej hodnotu derivace v prvnim bode, tj. f`(a)=');
  Da=input(' '); 
  fprintf('Zadej hodnotu derivace v poslednim bode, tj. f`(b)=');
  Db=input(' ');
else
  disp(' ');
  disp('Zadane hodnoty derivace v prvnim a poslednim bode');
  disp('pro spline s podminkami tecen:');
  tisk=['f`(',num2str(x(1)),')=',num2str(Da),' a '];
  tisk=[tisk,'f`(',num2str(x(n)),')=',num2str(Db)];
  disp(tisk)
end

[xk,fk,~]=polynom(x,f,deleni,1);  
xmin=min(xk);
xmax=max(xk);
fmin=min(fk);
fmax=max(fk);

% spline default v Matlabu 
% za f'(a) dosadi hodnotu derivace interpolacniho polynomu z prvnich 4
% uzlu v bode, podobne za f'(b) z poslednich 4 uzlu
xk=x(1):deleni:x(n);
fk=spline(x,f,xk);

fmin=min([fk,fmin]);
fmax=max([fk,fmax]);

set(figure(1),'Position',[7 3 28 15]);
clf;
hold on;
axis([xmin-presah/100*(xmax-xmin) xmax+presah/100*(xmax-xmin) ...
      fmin-presah/100*(fmax-fmin) fmax+presah/100*(fmax-fmin)]); 
plot(x,f,'ro');
popis=sprintf('Zadane body                       ');
texty(1,:)=popis(1:30); 
legend(texty,'Location','bestoutside');%legend(texty,-1);

disp(' ');
disp('Stiskni klavesu');
pause;

plot(xk,fk,'b');
popis=sprintf('Spline (Matlab)                   ');
texty(2,:)=popis(1:30); 
legend(texty,'Location','bestoutside'); %legend(texty,-1);
pause;
 
% PRIROZENE okrajove podminky  f''(a)=f''(b)=0 
 fnplt(csape(x,f,'variational'),'m');
 popis=sprintf('Spline - prirozene podminky        ');
 texty(3,:)=popis(1:30);
 legend(texty,'Location','bestoutside');%legend(texty,-1);
 pause;

% okrajove podminky PERIODICITY  f'(a)=f'(b) a f''(a)=f''(b))
 fnplt(csape(x,f,'periodic'),'g')
 popis=sprintf('Spline - podminky periodicity       ');
 texty(4,:)=popis(1:30); 
 legend(texty,'Location','bestoutside');%legend(texty,-1);
 pause;

% okrajove podminky TECEN f'(a)=Da, f'(b)=Db
 fnplt(csape(x,f,'complete',[Da,Db]),'k');
 popis=sprintf('Spline - podminky tecen             ');
 texty(5,:)=popis(1:30); 
 legend(texty,'Location','bestoutside');%legend(texty,-1);
 pause;


% Interpolacni polynom 
 [xk,fk,~]=polynom(x,f,deleni,1);  
 plot(xk,fk,'k--');
 popis=sprintf('Interpolacni polynom              ');
 texty(6,:)=popis(1:30); 
 legend(texty,'Location','bestoutside');%legend(texty,-1);
 





