function C=l2_aproximace_spojita(zobraz_vse,f,a,b,stupen)
%
% Sestroji spojitou L2-aproximaci pro funkci f=f(x) 
% na intervalu <a,b> pouzitim polynomu stupne stupen
%
% pri volbe zobraz_vse=1 zobrazi
% aproximace polynomy stupne 0 az do optimalniho stupne

clc;
pocet_deleni=500;
presah=15;
barva=['r','k','g','c'];
styl=['- ';'--';'-.';': '];

if ~exist('stupen')
  disp(' ');
  disp('  Chvilku strpeni  -  pocitam optimalni stupen polynomu ');
  disp(' ');
  opt_stupen=optimalni_stupen(f,a,b); 
  clc;
end  

figure(1);
clf;
hold on;
zoom on;
set(figure(1),'Units','centimeters');
set(figure(1),'Position',[10 3 18 15]);

deleni=(b-a)/pocet_deleni;
zoom on;

disp('-------------------------------------------------------------------');
if zobraz_vse~=1
 if exist('stupen') 
  n=stupen;
  fprintf('  Spojita L2-aproximace polynomem stupne %d\n',n);
 else
  n=opt_stupen; 
  fprintf('  Spojita L2-aproximace polynomem optimalniho stupne %d\n',n);
 end  
else
 if exist('stupen') 
  n=stupen;
  fprintf('  Spojita L2-aproximace polynomy stupnu 0 az %d\n',n);
 else
  n=opt_stupen; 
  fprintf('  Spojita L2-aproximace polynomy stupne 0 az optimalniho stupne %d\n',n);
 end
end
fprintf('  pro funkci f(x)=%s na intervalu <%f,%f>\n', f,a,b);
disp(' ');

%[baze,velikost]=ortogonalni_baze(a,b,n);
k=1;
for x=a:deleni:b
  yk(k)=eval(f);
  k=k+1;
end  
fmin=min(yk);
fmax=max(yk);
xmin=a;
xmax=b;
xk=a:deleni:b;
if zobraz_vse~=1
 C=normalni_rovnice(f,a,b,n);
 fk=polyval(C,xk);
 fmin=min([min(fk),fmin]);
 fmax=max([max(fk),fmax]);
else
 for i=0:n 
  C=normalni_rovnice(f,a,b,i);
  fk=polyval(C,xk);
  fmin=min([min(fk),fmin]);
  fmax=max([max(fk),fmax]);
 end
end 
 
set(figure(1),'Position',[7 3 32 15]);
clf;
hold on;
axis([xmin-presah/100*(xmax-xmin) xmax+presah/100*(xmax-xmin) ...
      fmin-presah/100*(fmax-fmin) fmax+presah/100*(fmax-fmin)]); 
plot(xk,yk,'b-');
popis=sprintf('Zadana funkce                             ');
texty(1,:)=popis(1:35); 
legend(texty,'Location','bestoutside');

disp(' ');
disp('Stiskni klavesu');
pause;

if zobraz_vse~=1
 plot(xk,fk,'m');
 popis=sprintf('L2-aproximace polynomem stupne %2d     ',n);
 texty(2,:)=popis(1:35); 
 legend(texty,'Location','bestoutside');
 text=['P_',num2str(n),'(x) = ',predpis_polynom(C)];
 disp(' ');
 disp(text);
 disp(' ');
else
 for i=0:n
  k=i+1; 
  color=strcat(barva(mod(k-1,4)+1),styl(mod(floor((k-1)/4),4)+1,:));
  C=normalni_rovnice(f,a,b,i);
  fk=polyval(C,xk);
  plot(xk,fk,color);
  popis=sprintf('L2-aproximace polynomem stupne %2d     ',i);
  texty(i+2,:)=popis(1:35); 
  legend(texty,'Location','bestoutside');
  text=['P_',num2str(i),'(x) = ',predpis_polynom(C)];
  disp(' ');
  disp(text);
  if i<n
    pause;
  else
    disp(' ');
  end 
 end 
end














