function koeficienty=lagrangeuv_polynom(zobraz_vse,x,f,presah)
%
% Sestroji Lagrangeuv interpolacni polynom 
% pro funkci zadanou tabulkou [x;f(x)]
%
% pro zobraz_vse=1 zobrazi vsechny dilci polynomy
% nejsou-li zadane vektory x,f => zadaji se mysi 

clc;
if ~exist('presah')
  presah=10;
end
pocet_deleni=1000;
clear texty;
barva=['r','m','g','c','k'];
styl=['- ';'--';'-.';': '];

figure(1);
clf;
hold on;
zoom on;
set(figure(1),'Units','centimeters');
set(figure(1),'Position',[10 3 18 15]);

if ~exist('zobraz_vse')
  zobraz_vse=0;
end
if ~exist('x') || ~exist('f')
  [x,f]=zadej_body;
  clc;
else
  xmin=min(x);
  xmax=max(x);
  fmin=min(f);
  fmax=max(f);
  axis([xmin-presah/100*(xmax-xmin) xmax+presah/100*(xmax-xmin) ...
	fmin-presah/100*(fmax-fmin) fmax+presah/100*(fmax-fmin)]); 
  for i=1:max(size(x))
    plot(x(i),f(i),'ro');
  end 
end 

[x,indexy]=sort(x);
f=f(indexy);
n=max(size(x));
deleni=(x(n)-x(1))/pocet_deleni;
zoom on;

disp('----------------------------------------------------------------');
fprintf('  Lagrangeuv interpolacni polynom pro funkci danou tabulkou\n');
disp(' ');
fprintf(' |    x(k)    |    f(k)    |\n');
fprintf(' ===========================\n');
for i=1:n
  fprintf(' | %9.4f  | %9.4f  |\n',x(i),f(i));
end 

[xk,fk]=polynom_L(x,f,deleni,presah/2);

xmin=min(xk);
xmax=max(xk);
fmin=min(fk);
fmax=max(fk);
if zobraz_vse==1
  for i=1:n
  pomf=zeros(size(f));
  pomf(i)=1;
  [~,fk]=polynom_L(x,pomf,deleni,presah/2);
  if fmin>min(fk)
    fmin=min(fk);
  end
  if fmax<max(fk)
    fmax=max(fk);
  end
 end
end
axis([xmin-presah/100*(xmax-xmin) xmax+presah/100*(xmax-xmin) ...
      fmin-presah/100*(fmax-fmin) fmax+presah/100*(fmax-fmin)]); 
disp(' ');
disp('Stiskni klavesu');
pause;

if zobraz_vse==1
 set(figure(1),'Position',[7 3 28 15]);
 for i=1:n+1
  clf;
  hold on;
  axis([xmin-presah/100*(xmax-xmin) xmax+presah/100*(xmax-xmin) ...
        fmin-presah/100*(fmax-fmin) fmax+presah/100*(fmax-fmin)]); 
  for k=1:min(i,n)
   pomf=zeros(size(f));
   pomf(k)=1;
   [xk,fk]=polynom_L(x,pomf,deleni,presah/2);
   color=strcat(barva(mod(k-1,5)+1),styl(mod(floor((k-1)/5),5)+1,:));
   plot(xk,fk,color);
   popis=sprintf('zakladni polynom L_%d(x)  ', k);
   texty(k,:)=popis(1:25); 
  end
  if i==n+1
   popis=sprintf('Vysledny polynom            ');
   texty(i,:)=popis(1:25); 
   [xk,fk,koeficienty]=polynom_L(x,f,deleni,presah/2);  
   plot(xk,fk,'b-');
  end  
   
  legend(texty,'Location','bestoutside');
    
  for k=1:min(i,n)
   pomf=zeros(size(f));
   pomf(k)=1;
   bbb=plot(x,pomf,'ko');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
  end
  bbb=plot(x,f,'ro');
  set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
  if i~=n+1
    pause;
  end
 end 
else
  [xk,fk,koeficienty]=polynom_L(x,f,deleni,presah/2);  
  plot(xk,fk,'b-');
  bbb=plot(x,f,'ro'); 
  set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
end

%n=max(size(koeficienty));
text=['L(x) = ',predpis_polynom(koeficienty)];
disp(' ');
disp(text);
disp(' ');

% koeficienty = polyfit(x,f,max(size(x))-1)
