function taylor_polynom(f,x0,polomer,max_stupen,zobraz_vse)
%
% Sestroji Tayloruv polynom stupne n (n=0,1,...,max_stupen)
% pro symbolicky zadanou funkci f v bode x0 
% na okoli <x0-polomer,x0+polomer>
% (pro zobraz_vse=1 zobrazi vsechny polynomy)

clc;

is_symbolic=is_toolbox('symbolic');

if ~is_symbolic
  clc;
  disp(' ');
  disp('Lituji, ale neni k dispozici Symbolic Math Toolbox !');
  disp(' '); 
else

disp('----------------------------------------------------------------');
fprintf('  Tayloruv polynom stupne n (n=0,...,%d)\n',max_stupen);
fprintf('  pro funkci f(x)=%s\n',f);
fprintf('  v bode x0=%f\n',x0);
fprintf('  zobrazi na intervalu <%f,%f>\n',x0-polomer,x0+polomer);

if zobraz_vse==1
   fprintf('  polynomy vsech stupnu\n');
else
   fprintf('  polynom aktualniho stupne\n');
end
disp('----------------------------------------------------------------');

deleni=100;
y=zeros(deleni+1,max_stupen+2);
z=y;
a=x0-polomer;
b=x0+polomer;
krok=(b-a)/deleni;
barva=['r','c','g','k'];
styl=['- ';'--';'-.';': '];

figure(1);
clf;
hold on;
zoom on;
set(figure(1),'Units','centimeters');
set(figure(1),'Position',[10 3 30 15]);

x = sym('x');
d=eval(f);
pom1=eval(f);
for i=1:max_stupen
  pom2=diff(pom1,x);
  d=[d,pom2];
  pom1=pom2;
end

x=x0;
for j=1:max_stupen+1
  %hodnoty(j)=eval(d(j));
  hodnoty(j) = subs(d(j),x);
end

i=1;
for x=a:krok:b
  z(i,1)=eval(f);
  i=i+1;
end

for j=2:max_stupen+2
 i=1; 
 for x=a:krok:b
  y(i,j)=hodnoty(j-1)*(x-x0)^(j-2)/factorial(j-2);
  i=i+1;
 end
end

for i=2:max_stupen+2
 z(:,i)=sum(y(:,2:i),2);
end

max_y=max(max(z));
min_y=min(min(z));
sx=b-a;
sy=max_y-min_y;

for i=2:max_stupen+2
  clear texty;
  clf;
  axis([a-0.05*sx b+0.05*sx min_y-0.05*sy max_y+0.05*sy]);
  hold on;
  x=a:krok:b;
  plot(x,z(:,1),'b-');
  texty(1,:)=sprintf('zadana funkce                 ');
  if zobraz_vse==1
    for j=2:i-1
      color=strcat(barva(mod(j-2,4)+1),styl(mod(floor((j-2)/4),4)+1,:));
      plot(x,z(:,j),color);
      pom=sprintf('Tayloruv polynom %d.stupne     ', j-2);
      texty(j,:)=pom(1:30); 
    end     
  end
  if zobraz_vse~=1
    pom=sprintf('Tayloruv polynom %d.stupne     ', i-2);
    texty(2,:)=pom(1:30);
  else
    pom=sprintf('Tayloruv polynom %d.stupne     ', i-2);
    index=size(texty,1);
    texty(index+1,:)=pom(1:30);
  end
  color='m-';
  plot(x,z(:,i),color);
 
  legend(texty,'Location','bestoutside');
  
  bbb = plot(x0,hodnoty(1),'ro');
  set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
  disp('Stiskni klavesu');
  pause;
end  

end









