function uzly=uzly_cebysev(a,b,N,zobraz)
%
% vypocte uzly jako koreny Cebysevovych polynomu
% na intervalu <a,b>, jejich pocet je N

clc;
presah=10;
pocet_deleni=1000;
deleni=(b-a)/pocet_deleni;

old_uzly=a:(b-a)/(N-1):b;
xx=a:deleni:b;
k=0;
for i=a:deleni:b
  k=k+1;
  old_yy(k)=pom_fce(i,old_uzly);
end

for i=1:N
  x(i)=cos((2*(i-1)+1)/N*pi/2);
end

for i=1:N
  uzly(i)=(b-a)/2*x(i)+(a+b)/2;
end
k=0;
for i=a:deleni:b
  k=k+1;
  yy(k)=pom_fce(i,uzly);
end

if exist('zobraz') 
  if zobraz==1   
    disp('----------------------------------------------------------------');
    fprintf(' Ukazka minimalizace chyby pri interpolaci\n');
    fprintf(' pouzitim neekvidistantnich uzlu - korenu Cebysevovych polynomu\n');
    disp(' ');
    figure(1);
    set(figure(1),'Units','centimeters');
    set(figure(1),'Position',[10 3 18 15]);
    clf;
    hold on;
    xmin=a-(b-a)*presah/100;
    xmax=b+(b-a)*presah/100;
    fmin=min([old_yy,yy]);
    fmax=max([old_yy,yy]);
    vyska=fmax-fmin;
    fmin=fmin-vyska*presah/100;
    fmax=fmax+vyska*presah/100;
    axis([xmin xmax fmin fmax]); 
    plot(xx,old_yy,'b-');
    plot(old_uzly,zeros(size(old_uzly)),'ro');
    plot(xx,yy,'m-');
    plot(uzly,zeros(size(uzly)),'go');
  end
end  

