function derivace_richardson(vzorec, f, x0, h, N)
%
% Vypocte hodnotu prvni derivace zadane funkce f v bode x0 
% s kroky h, h/2, h/4, ... h/2^N
% pomoci prave, leve nebo centralni pomerne diference (vzorec)

clc;
disp('----------------------------------------------------------------');
fprintf('  Vypocte hodnotu prvni derivace zadane funkce \n');
fprintf('  f=%s v bode x0=%f s kroky\n',f,x0);


kroky=sprintf('  h=[');
for j=1:N+1
  kroky=[kroky,sprintf('%g',h/(2^(j-1)))];
  if j<=N
    kroky=[kroky,', '];
  else 
    kroky=[kroky,']'];
  end
end
disp(kroky);
disp(' ');
if strncmp(vzorec,'D_P',3)
  fprintf('  Pro vypocet se pouzije vzorec prave pomerne diference D_P.\n'); 
  fprintf('  Ke zpresneni se pouzije Richardsonova extrapolace.\n');
else 
  if strncmp(vzorec,'D_L',3)
    fprintf('  Pro vypocet se pouzije vzorec leve pomerne diference D_L.\n'); 
    fprintf('  Ke zpresneni se pouzije Richardsonova extrapolace.\n');
  else
    if strncmp(vzorec,'D_C',3)
      fprintf('  Pro vypocet se pouzije vzorec centralni pomerne diference D_C.\n'); 
      fprintf('  Ke zpresneni se pouzije Richardsonova extrapolace.\n');
    else
      disp(' ');
      fprintf('  Neni zadan zadny vzorec ("D_P", "D_L", "D_C") !!!\n'); 
      disp('----------------------------------------------------------------');
      return;   
      %break;
    end
  end
end
disp('----------------------------------------------------------------');


for i=1:N+1
  [der_fce,D_P,D_L,D_C]=derivace_vypocet(f, x0, h/(2^(i-1)), 0);
  if strncmp(vzorec,'D_P',3) 
    D(i)=D_P;
    m=1;
  else 
    if strncmp(vzorec,'D_L',3)
      D(i)=D_L;
      m=1;
    else 
      if strncmp(vzorec,'D_C',3)
        D(i)=D_C;
        m=2;
      end
    end
  end
end

TAB=zeros(N+1);
TAB(:,1)=D';
for i=2:N+1
  for j=i:N+1 
    TAB(j,i)=TAB(j,i-1)-(TAB(j,i-1)-TAB(j-1,i-1))/(1-2^((i-1)*m));
  end
end

disp(' ');
tiskni=sprintf(' !     h     |  %s(f,x0,h)  | ',vzorec(1:3));
for i=1:N
  tiskni=[tiskni,sprintf('  %d.korekce   | ',i)];
end
disp(tiskni);
pom=' ';
for i=1:length(tiskni)-2
  pom=[pom,'='];
end
disp(pom)
for i=1:N+1
  tiskni=sprintf(' |  %5.5f  ',h/(2^(i-1)));
  for j=1:i
    tiskni=[tiskni,sprintf('| %12.9f  ',TAB(i,j))];
  end
  tiskni=[tiskni,sprintf('|')];
  disp(tiskni);
end
disp(' ');
fprintf('  Presna hodnota derivace funkce f v bode x0 je  %15.12f\n',der_fce); 
disp(' ');

