function [X,Y]=jednokrokove_metody(f, y0, x0, xn, h)
%
% Provede srovnani jednokrokovych metod pro 
% reseni obycejne diferencialni rovnice 1. radu
%                      y'=f(x,y(x))
% s pocatecni podminkou
%                       y(x0)=y0
% na intervalu  <x0,xn>.
% Pro diskretizaci pouzije krok h 

clc;
disp('----------------------------------------------------------------');
fprintf('  JEDNOKROKOVE METODY pro reseni\n');
disp(' ');
fprintf('  obycejne diferencialni rovnice 1. radu\n');
fprintf('                    y`=%s\n',f);
fprintf('  s pocatecni podminkou\n');
fprintf('                    y(%f)=%f\n',x0,y0);
fprintf('  na intervalu\n');
fprintf('                    < %f, %f >\n',x0,xn);
fprintf('  s krokem h=%f\n',h);
disp('----------------------------------------------------------------');
disp(' ');
disp('  Chvilku strpeni, probiha vypocet.  ');
disp(' ');

% VYPOCTY
[~,Y1]=eulerova_metoda( f, y0, x0, xn, h, 0);
[~,Y2]=taylorova_metoda( f, y0, x0, xn, h, 2, 0);
[~,Y3]=taylorova_metoda( f, y0, x0, xn, h, 3, 0);
[~,Y4]=taylorova_metoda( f, y0, x0, xn, h, 4, 0);
[~,Y5]=modifikovana_eulerova_metoda( f, y0, x0, xn, h, 0);
[X,Y6]=heunova_metoda( f, y0, x0, xn, h, 0);

Y=[Y1; Y2; Y3; Y4; Y5; Y6];
disp('  Stiskni libovolnou klavesu.');
disp(' ');
max_y=max([Y1,Y2,Y3,Y4,Y5,Y6]);
min_y=min([Y1,Y2,Y3,Y4,Y5,Y6]);
sy=max_y-min_y;
n=length(X);
sx=X(n)-X(1);
figure(1);
clf;
hold on;
zoom on;
axis([X(1)-.15*sx X(length(X))+.15*sx min_y-.15*sy max_y+.15*sy]);

texty(1,:)=sprintf(' Pocatecni podminka            ');
texty(2,:)=sprintf(' Eulerova metoda               ');
texty(3,:)=sprintf(' Metoda Taylorova typu 2. radu ');
texty(4,:)=sprintf(' Metoda Taylorova typu 3. radu ');
texty(5,:)=sprintf(' Metoda Taylorova typu 4. radu ');
texty(6,:)=sprintf(' Modifikovana Eulerova metoda  ');
texty(7,:)=sprintf(' Heunova metoda                ');

title('Jednokrokove metody');
plot(X(1),Y1(1),'ro');
legend(texty(1,:),'Location','bestoutside');
pause;
i=2;
   plot(X(i-1:i),Y1(i-1:i),'b-');
   plot(X(i-1:i),Y2(i-1:i),'m-');
   plot(X(i-1:i),Y3(i-1:i),'g-');
   plot(X(i-1:i),Y4(i-1:i),'k-');
   plot(X(i-1:i),Y5(i-1:i),'r-');
   plot(X(i-1:i),Y6(i-1:i),'c-');
   legend(texty,'Location','bestoutside');
   pause
for i=3:n
   bbb=plot(X(i-1:i),Y1(i-1:i),'b-');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
   bbb=plot(X(i-1:i),Y2(i-1:i),'m-');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
   bbb=plot(X(i-1:i),Y3(i-1:i),'g-');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
   bbb=plot(X(i-1:i),Y4(i-1:i),'k-');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
   bbb=plot(X(i-1:i),Y5(i-1:i),'r-');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
   bbb=plot(X(i-1:i),Y6(i-1:i),'c-');
   set(get(get(bbb,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
   if i<n
     pause
   end
end










