%
% Grafick znzornn konvergence Newtonovy metody
% pro rovnici x^3-1=0 v komplexni promenne
% na ctverci (-1,1)x(-1,1)
% (Rzn barvy znzoruj konvergenci k rznm eenm.) 
%

clc;
disp(' ');
disp(' Graficke znazorneni konvergence Newtonovy metody')
disp(' pro rovnici x^3-1=0 v komplexni promenne')
disp(' na ctverci <-1,1> x <-1,1>')
disp(' (Ruzne barvy znazornuji konvergenci k ruznym resenim)') 
disp(' ');
disp('   Chvilku strpeni - provadi se vypocet ');
disp(' ');

% Volba oblasti
%
	frac_steps = 0.025;
	frac_max_re = 1;
	frac_min_re = -1;
	frac_max_im = 1;
	frac_min_im = -1;
%
	re_x=frac_min_re:frac_steps:frac_max_re;
	im_x=frac_min_im:frac_steps:frac_max_im;

% Grafick znzornn oblasti:

figure(1);
clf;
hold on;
zoom on;
grid off;
axis([frac_min_re frac_max_re frac_min_im frac_max_im]);

% Opakovan voln Newtonovy metody pro rzn poten aproximace:

i=sqrt(-1);

tolerantion=0.1;
max_iter=100;
c=.5;

for k=frac_min_re:frac_steps:frac_max_re
   for l=frac_min_im:frac_steps:frac_max_im
      aprox=k+i*l;
      [out, nm_error, iteraci] = ...
	   newtonova_metoda_pom('fce10','der_fce10',aprox, tolerantion, max_iter);
      if (abs(1-out)<tolerantion) 
        color='b';
      elseif  (abs(0.5+sqrt(3)/2*i+out)<tolerantion) 
        color='r';
      else
        color='y';      
      end
      oo=fill([k k+c*frac_steps k+c*frac_steps k],...
              [l l l+c*frac_steps l+c*frac_steps],color);
      set(oo,'EdgeColor',color)
   end
end

hold off;

