function [reseni,pocet_kroku,konverguje] = metoda_proste_iterace(funkce_phi,x0,epsilon,max_pocet_kroku)

% resime rovnici f(x)=0 na intervalu <a,b>
% pouzijeme prepis  x=funkce_phi(x)
% pocatecni aproximace  x0 
% zastavovaci podminka  |x_(k+1) - x_(k)| < epsilon 
% maximalni pocet kroku  max_pocet_kroku

clc;
tisk=sprintf('Metoda proste iterace pro reseni nelinearni rovnice x=phi(x)');
disp(tisk);
tisk=sprintf('pro pocatecni aproximaci x0=%0.8g a zastavovaci podminku |x(k)-x(k-1)|<%0.8g',...
	     x0,epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce funkce_phi(x) je zadana v souboru %s.m takto:',funkce_phi);
disp(tisk);
nazev=sprintf('%s.m',funkce_phi);
type(nazev)

%info=0;
konverguje=1;
pocet_kroku=0;
x_new=x0;
dx_new=inf;

  tisk=sprintf( ... 
  '| krok |       x(k)       | dx(k)=x(k)-x(k-1) |   dx(k)/dx(k-1)   | ');
    disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
   disp(retezec);

while (abs(dx_new)>epsilon) && (pocet_kroku<max_pocet_kroku)
  if pocet_kroku==0
     tisk=sprintf('| %4.0f |    %9.6f     |                   |                   |',... 
	          pocet_kroku, x_new);
  else 
    if pocet_kroku==1
      tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |                   |',... 
	          pocet_kroku, x_new, dx_new);
    else  
      tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |     %9.6f     |',... 
	           pocet_kroku, x_new, dx_new, dx_new/dx_old);
    end  
  end    
  disp(tisk);
  x_old=x_new;
  x_new=feval(funkce_phi,x_new);
  dx_old=dx_new;
  dx_new=x_new-x_old;
  pocet_kroku=pocet_kroku+1;
  if abs(dx_new/dx_old)>1
    konverguje=0;
  end  
end
tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |     %9.6f     |',... 
	      pocet_kroku, x_new, dx_new, dx_new/dx_old);
disp(tisk);
reseni=x_new; 







