function [reseni,pocet_kroku,konverguje] = metoda_proste_iterace_G(funkce_phi,a,b,x0,epsilon,max_pocet_kroku)

% resime rovnici f(x)=0 na intervalu <a,b>
% pouzijeme prepis  x=funkce_phi(x)
% pocatecni aproximace  x0 
% zastavovaci podminka  |x_(k+1) - x_(k)| < epsilon 
% maximalni pocet kroku  max_pocet_kroku

clc;
tisk=sprintf('Metoda proste iterace pro reseni nelinearni rovnice x=phi(x)');
disp(tisk);
tisk=sprintf('pro pocatecni aproximaci x0=%0.8g a zastavovaci podminku |x(k)-x(k-1)|<%0.8g',...
	     x0,epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce funkce_phi(x) je zadana v souboru %s.m takto:',funkce_phi);
disp(tisk);
nazev=sprintf('%s.m',funkce_phi);
type(nazev)

figure(1);
clf;
hold on;
zoom on;

krok=(b-a)/1000;
ymin=inf;
ymax=-inf;

for x=a:krok:b
phi_x=feval(funkce_phi,x);
  if phi_x>ymax
    ymax=phi_x;
  end
  if phi_x<ymin
    ymin=phi_x;
  end
  if x>ymax
    ymax=x;
  end
  if x<ymin
    ymin=x;
  end
end
sx=b-a;
sy=ymax-ymin;
axis([a-0.05*sx b+0.05*sx ymin-0.05*sy ymax+0.05*sy]);

i=0;
for x=a:krok:b
  i=i+1;
  y(i)=feval(funkce_phi,x);
end
x=a:krok:b;
plot(x,y,'b');
plot([a-0.05*sx,b+0.05*sx],[0,0],'k');
plot([0,0],[ymin-0.05*sy,ymax+0.05*sy],'k');
plot([a,b],[a,b],'m-');
phi_a=feval(funkce_phi,a);
phi_b=feval(funkce_phi,b);
plot([a,a],[0,phi_a],'k--');
plot([b,b],[0,phi_b],'k--');

konverguje=1;
pocet_kroku=0;
x_new=x0;
dx_new=inf;

  tisk=sprintf( ... 
  '| krok |       x(k)       | dx(k)=x(k)-x(k-1) |   dx(k)/dx(k-1)   | ');
    disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
   disp(retezec);
  
phi_x_new=feval(funkce_phi,x_new);
plot([x_new,x_new],[0,phi_x_new],'k--');
while (abs(dx_new)>epsilon) && (pocet_kroku<max_pocet_kroku)
  if pocet_kroku==0
     tisk=sprintf('| %4.0f |    %9.6f     |                   |                   |',... 
	          pocet_kroku, x_new);
  else 
    if pocet_kroku==1
      tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |                   |',... 
	          pocet_kroku, x_new, dx_new);
    else  
      tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |     %9.6f     |',... 
	           pocet_kroku, x_new, dx_new, dx_new/dx_old);
    end  
  end    
  disp(tisk);
  pause;
  x_old=x_new;
  x_new=feval(funkce_phi,x_new);
  plot([x_new,x_old],[x_new,x_new],'k--');
  plot([x_new,x_new],[0,x_new],'k--');
  plot([x_old,x_old],[0,x_new],'k--');
  dx_old=dx_new;
  dx_new=x_new-x_old;
  pocet_kroku=pocet_kroku+1;
  if abs(dx_new/dx_old)>1
    konverguje=0;
  end  
end
tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |     %9.6f     |',... 
	      pocet_kroku, x_new, dx_new, dx_new/dx_old);
disp(tisk);
reseni=x_new; 







