function [reseni,pocet_kroku,konverguje] = ...
          metoda_proste_iterace_soustava(funkce_phi,x0,epsilon,max_pocet_kroku)

% resime soustavu rovnic F(x)=0, kde
% pouzijeme prepis  x=Funkce_phi(x)
% pocatecni aproximace  x0 
% zastavovaci podminka  ||x_(k+1) - x_(k)|| < epsilon 
% maximalni pocet kroku  max_pocet_kroku

n=max(size(x0));
clc;
tisk=sprintf(...
'Metoda proste iterace pro reseni soustavy nelinearnich rovnic');
disp(tisk);
disp('   F(x)=0    s vyuzitim prepisu na tvar    x=Funkce_phi(x)'); 
if n==2
tisk=sprintf('pro pocatecni aproximaci x0=[%0.8g,%0.8g] a',x0(1),x0(2)); 
end
if n==3
tisk=sprintf('pro pocatecni aproximaci x0=[%0.8g,%0.8g,%0.8g] a',x0(1),x0(2),x0(3)); 
end
disp(tisk);
tisk=sprintf('zastavovaci podminku ||x(k)-x(k-1)||<%0.8g',epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce Funkce_phi(x) je zadana v souboru %s.m takto:',funkce_phi);
disp(tisk);
nazev=sprintf('%s.m',funkce_phi);
type(nazev)

konverguje=1;
pocet_kroku=0;
x_new=x0;
dx_new=inf;

  tisk=sprintf( ... 
  '| krok |      x_1(k)      |      x_2(k)      |  ||x(k)-x(k-1)||  | ');
    disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
   disp(retezec);

while (dx_new>epsilon) && (pocet_kroku<max_pocet_kroku)
  if pocet_kroku==0
     tisk=sprintf('| %4.0f |    %9.6f     |    %9.6f     |                   |',... 
	          pocet_kroku, x_new(1), x_new(2));
  else 
     tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f    |     %9.6f     |',... 
	          pocet_kroku, x_new(1), x_new(2), dx_new);
  end    
  disp(tisk);
  x_old=x_new;
  x_new=feval(funkce_phi,x_new);
  dx_old=dx_new;
  dx_new=norm(x_new-x_old);
  pocet_kroku=pocet_kroku+1;
  if abs(dx_new/dx_old)>1
    konverguje=0;
  end  
end

tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f    |     %9.6f     |',... 
	          pocet_kroku, x_new(1), x_new(2), dx_new);
disp(tisk);
reseni=x_new; 







