function [reseni,pocet_kroku,info] = metoda_puleni_intervalu_G(funkce,a,b,epsilon,meritko_osy,zast_podm)

% resime rovnici f(x)=0 na intervalu <a,b>
% zastavovaci podminka       b-a < epsilon 
% pro meritko_osy==1 vykresli obrazek s osami se stejnym meritkem
% pro zast_podm==1 vypise vysledky pro podminku na delku intervalu i na funkcni hodnotu 

clc;
tisk=sprintf('Metoda puleni intervalu pro reseni nelinearni rovnice f(x)=0');
disp(tisk);
tisk=sprintf('na intervalu <%0.8g,%0.8g> a zastavovaci podminku b-a<%0.8g', a,b,epsilon);
disp(tisk);
if exist('zast_podm') && zast_podm==1
 tisk=sprintf('a soucasne pro zastavovaci podminku abs(f(s))<%0.8g',epsilon);
 disp(tisk);
end
disp(' ');
tisk=sprintf('Funkce f(x) je zadana v souboru %s.m takto:',funkce);
disp(tisk);
nazev=sprintf('%s.m',funkce);
type(nazev)

info=0;
pocet_kroku=0;
fs=1;
aa=a;
bb=b;

figure(1);
clf;
hold on;
zoom on;

if exist('meritko_osy') && meritko_osy==1
  axis equal;
end

krok=(b-a)/1000;
ymin=inf;
ymax=-inf;
for x=a:krok:b
  fx=feval(funkce,x);
  if fx>ymax
    ymax=fx;
  end
  if fx<ymin
    ymin=fx;
  end
end
sx=b-a;
sy=ymax-ymin;

tisk=sprintf( ... 
  '| krok |     a     |     b     |     s     |    f(a)   |    f(b)   |    f(s)   |');
  disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
   disp(retezec);

fa=feval(funkce,a);
fb=feval(funkce,b);

% test podminky f(a).f(b)<0
if fa*fb>0
  reseni=NaN;
  info=1;
  if fa>0
    axis([a-0.05*sx b+0.05*sx -0.1 ymax+0.05*sy]);
    plot([0,0],[-0.1,ymax+0.05*sy],'k');
  else
    axis([a-0.05*sx b+0.05*sx ymin-0.05*sy 0.1]);
    plot([0,0],[ymin-0.05*sy,0.1],'k');
  end    
else
  axis([a-0.05*sx b+0.05*sx ymin-0.05*sy ymax+0.05*sy]);
end  
set(gcf,'Visible', 'on');
if fa==0
  reseni=a;
  fs=0;
end
if fb==0
  reseni=b;
  fs=0;
end

i=0;
for x=a:krok:b
  i=i+1;
  fx=feval(funkce,x);
  y(i)=fx;
end
x=a:krok:b;
plot(x,y,'b');
plot([a-0.05*sx,b+0.05*sx],[0,0],'k');
plot([0,0],[ymin-0.05*sy,ymax+0.05*sy],'k');
plot([a,a],[0,fa],'k--');
plot([b,b],[0,fb],'k--');

if info==0

 if exist('zast_podm') && zast_podm==1
  lab1=0;
  lab2=0;
  while ((b-a)>epsilon/2) || abs(fs)>epsilon
    pause;
    s=(a+b)/2;
    fs=feval(funkce,s);
    plot([s,s],[0,fs],'k--');
    ooo=plot([aa,bb],[0,0],'w-');
    set(ooo,'LineWidth',2);
    plot([aa,bb],[0,0],'k-');
    ooo=plot([a,b],[0,0],'r-');
    set(ooo,'LineWidth',2);
    tisk=sprintf('| %4.0f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f |',...
	          pocet_kroku, a, b, s, fa, fb, fs);
    disp(tisk);
    if fs==0 
      reseni=s;
      fs=0;
    else  
      pocet_kroku=pocet_kroku+1;
      if fa*fs<0
	b=s;
        fb=fs;
      else
	a=s;
	fa=fs;
      end	
    end
    if abs(fs)<epsilon & lab1==0
     fprintf(' Zastaveni vypoctu pro podminku na  abs(f(s)) < %f\n',epsilon);
     disp(' ');
     lab1=1;
    end
    if (b-a)<epsilon/2 & lab2==0
     fprintf(' Zastaveni vypoctu pro podminku na     b-a < %f\n',epsilon);
     disp(' ');
     lab2=1;
    end
  end
  if fs~=0
    reseni=(a+b)/2;
  end
  if exist('meritko_osy') && meritko_osy==1
    disp(' ')
    fprintf(' Delka posledniho intervalu je               b-a = %f\n',(b-a)*2);   
    fprintf(' Abs. hodnota funkcni hodnoty v bode s je    f(s)= %f\n',abs(fs));
  end

 else

  while ((b-a)>epsilon/2)  && fs~=0 
    pause;
    s=(a+b)/2;
    fs=feval(funkce,s);
    plot([s,s],[0,fs],'k--');
    ooo=plot([aa,bb],[0,0],'w-');
    set(ooo,'LineWidth',2);
    plot([aa,bb],[0,0],'k-');
    ooo=plot([a,b],[0,0],'r-');
    set(ooo,'LineWidth',2);
    tisk=sprintf('| %4.0f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f |',...
	          pocet_kroku, a, b, s, fa, fb, fs);
    disp(tisk);
    if fs==0 
      reseni=s;
      fs=0;
    else  
      pocet_kroku=pocet_kroku+1;
      if fa*fs<0
	b=s;
        fb=fs;
      else
	a=s;
	fa=fs;
      end	
    end
  end
  if fs~=0
    reseni=(a+b)/2;
  end
  if exist('meritko_osy') && meritko_osy==1
    disp(' ')
    fprintf(' Delka posledniho intervalu je               b-a = %f\n',(b-a)*2);   
    fprintf(' Abs. hodnota funkcni hodnoty v bode s je    f(s)= %f\n',abs(fs));
  end
 
 end  

end












