function [reseni,pocet_kroku,info] = metoda_regula_falsi(funkce,a,b,epsilon)

% resime rovnici f(x)=0 na intervalu <a,b>
% zastavovaci podminka       |f(s)| < epsilon 

clc;
tisk=sprintf('Metoda regula falsi pro reseni nelinearni rovnice f(x)=0');
disp(tisk);
tisk=sprintf('na intervalu <%0.8g,%0.8g> a zastavovaci podminku |f(s)|<%0.8g', a,b,epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce f(x) je zadana v souboru %s.m takto:',funkce);
disp(tisk);
nazev=sprintf('%s.m',funkce);
type(nazev)

info=0;
pocet_kroku=0;
fs=1;

  tisk=sprintf( ... 
  '| krok |     a     |     b     |     s     |    f(a)   |    f(b)   |    f(s)   |');
  disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
   disp(retezec);

fa=feval(funkce,a);
fb=feval(funkce,b);

% test podminky f(a).f(b)<0
if fa*fb>0
  reseni=NaN;
  info=1;
end  
if fa==0
  reseni=a;
  fs=0;
end
if fb==0
  reseni=b;
  fs=0;
end

if info==0
  while (fs~=0) 
    fa=feval(funkce,a);
    fb=feval(funkce,b);
    s=a-(b-a)*fa/(fb-fa);
    tisk=sprintf('| %4.0f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f |',...
	          pocet_kroku, a, b, s, f(a), fb, fs);
    disp(tisk);
    fs=feval(funkce,s);
    if abs(fs)<epsilon 
      reseni=s;
      fs=0;
    else  
      pocet_kroku=pocet_kroku+1;
      if fa*fs<0
	b=s;
      else 
        a=s;
      end	
    end
  end
  if fs~=0
    reseni=(a+b)/2;
  end
end









