function [reseni,pocet_kroku,info] = metoda_regula_falsi_G(funkce,a,b,epsilon)

% resime rovnici f(x)=0 na intervalu <a,b>
% zastavovaci podminka       b-a < epsilon 

clc;
tisk=sprintf('Metoda regula falsi pro reseni nelinearni rovnice f(x)=0');
disp(tisk);
tisk=sprintf('na intervalu <%0.8g,%0.8g> a zastavovaci podminku |f(s)|<%0.8g', a,b,epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce f(x) je zadana v souboru %s.m takto:',funkce);
disp(tisk);
nazev=sprintf('%s.m',funkce);
type(nazev)

info=0;
pocet_kroku=0;
fs=1;

figure(1);
clf;
hold on;
zoom on;

krok=(b-a)/1000;
ymin=inf;
ymax=-inf;
for x=a:krok:b
  fx=feval(funkce,x);
  if fx>ymax
    ymax=fx;
  end
  if fx<ymin
    ymin=fx;
  end
end
sx=b-a;
sy=ymax-ymin;

  tisk=sprintf( ... 
  '| krok |     a     |     b     |     s     |    f(a)   |    f(b)   |    f(s)   |');
  disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
   disp(retezec);

fa=feval(funkce,a);
fb=feval(funkce,b);

% test podminky f(a).f(b)<0
if fa*fb>0
  reseni=NaN;
  info=1;
  if fa>0
    axis([a-0.05*sx b+0.05*sx -0.1 ymax+0.05*sy]);
    plot([0,0],[-0.1,ymax+0.05*sy],'k');
  else
    axis([a-0.05*sx b+0.05*sx ymin-0.05*sy 0.1]);
    plot([0,0],[ymin-0.05*sy,0.1],'k');
  end    
else
  axis([a-0.05*sx b+0.05*sx ymin-0.05*sy ymax+0.05*sy]);
end  

i=0;
for x=a:krok:b
  i=i+1;
  y(i)=feval(funkce,x);
end
x=a:krok:b;
plot(x,y,'b');
plot([a-0.05*sx,b+0.05*sx],[0,0],'k');
plot([0,0],[ymin-0.05*sy,ymax+0.05*sy],'k');
plot([a,a],[0,fa],'k--');
plot([b,b],[0,fb],'k--');
if fa==0
  reseni=a;
  fs=0;
end
if fb==0
  reseni=b;
  fs=0;
end


if info==0
  while (fs~=0) 
    pause;
    fa=feval(funkce,a);
    fb=feval(funkce,b);
    s=a-(b-a)*fa/(fb-fa);
    fs=feval(funkce,s);
    plot([s,s],[0,fs],'k--');
    plot([a,b],[fa,fb],'m-');
    tisk=sprintf('| %4.0f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f | %9.4f |',...
	          pocet_kroku, a, b, s, fa, fb, fs);
    disp(tisk);
    if abs(fs)<epsilon 
      reseni=s;
      fs=0;
    else  
      pocet_kroku=pocet_kroku+1;
      if fa*fs<0
	b=s;
      else 
        a=s;
      end	
    end
  end
  if fs~=0
    reseni=(a+b)/2;
  end
end















