function [reseni, chyba, iterace] = metoda_secen(funkce,x0,x1,epsilon,max_iter)
%Implementace metody secen pro reseni nelinearni rovnice f(x)=0
%
%	vstupni parametry:
%	funkce			- odkaz na zadanou funkci
%	derivace		- odkaz na derivaci zadane funkce
%	x0, x1			- dve pocatecni aproximace 
%	epsilon 		- nastaveni pozadovane presnosti 
%	max_iter		- nastaveni maximalniho poctu iteraci 
%
%	vystupni paramery:
%	reseni			- posledni aproximace reseni
%	chyba   		- rozdil dvou po sobe jdoucich aproximaci
%	iterace			- pocet iteracnich kroku metody

clc;
tisk=sprintf('Metoda secen pro reseni nelinearni rovnice f(x)=0');
disp(tisk);
tisk=sprintf('pro pocatecni aproximace x0=%0.8g, x1=%0.8g',x0,x1); 
disp(tisk);
tisk=sprintf('a zastavovaci podminku |x(k)-x(k-1)|<%0.8g',epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce f(x) je zadana v souboru %s.m takto:',funkce);
disp(tisk);
nazev=sprintf('%s.m',funkce);
type(nazev)

  iterace = 0;
  tmp1    = x0;
  tmp2    = x1;
  fce1    = feval(funkce,tmp1);
  fce2    = feval(funkce,tmp2);
  chyba   = abs(tmp2 - tmp1);

  tisk=sprintf( ... 
  '| iterace |       x(k)       | dx(k)=x(k)-x(k-1) | ');
  disp(tisk)
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
  disp(retezec);

  tisk=sprintf('| %7.0f | %16.8f |                   |', iterace, tmp1 );
  disp(tisk)
  iterace=iterace+1;
  tisk=sprintf('| %7.0f | %16.8f | %17.8f |', iterace, tmp2, chyba );
  disp(tisk)

  while (iterace < max_iter) && (chyba > epsilon)
    tmp0     = tmp1;
    tmp1     = tmp2;
    fce0     = fce1;
    fce1     = feval(funkce,tmp1);
    tmp2     = tmp1 - fce1/(fce1-fce0)*(tmp1-tmp0);
    chyba    = abs(tmp2 - tmp1);
    iterace  = iterace + 1;
    fprintf('| %7.0f | %16.8f | %17.8f |\n', iterace, tmp2, chyba);
  end
  reseni    = tmp2;



