function [reseni, chyba, iterace] = metoda_secen_G(funkce,x0,x1,epsilon,max_iter)
%Implementace metody secen pro reseni nelinearni rovnice f(x)=0
%
%	vstupni parametry:
%	funkce			- odkaz na zadanou funkci
%	derivace		- odkaz na derivaci zadane funkce
%	x0, x1			- dve pocatecni aproximace 
%	epsilon 		- nastaveni pozadovane presnosti 
%	max_iter		- nastaveni maximalniho poctu iteraci 
%
%	vystupni paramery:
%	reseni			- posledni aproximace reseni
%	chyba   		- rozdil dvou po sobe jdoucich aproximaci
%	iterace			- pocet iteracnich kroku metody

clc;
tisk=sprintf('Metoda secen pro reseni nelinearni rovnice f(x)=0');
disp(tisk);
tisk=sprintf('pro pocatecni aproximace x0=%0.8g, x1=%0.8g',x0,x1); 
disp(tisk);
tisk=sprintf('a zastavovaci podminku |x(k)-x(k-1)|<%0.8g',epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce f(x) je zadana v souboru %s.m takto:',funkce);
disp(tisk);
nazev=sprintf('%s.m',funkce);
type(nazev)

% Pouze pro potreby vykreslovani
  figure(1);
  clf;
  hold on;
  zoom on;

  pom=zeros(max_iter+3,1);
  pom(1)=x0;
  pom(2)=x1;
  pomfce=zeros(max_iter+3,1);
  pomfce(1)=feval(funkce,x0);
  pomfce(2)=feval(funkce,x1);
  
  iterace = 2;
  tmp1    = x0;
  tmp2    = x1;
  fce1    = feval(funkce,tmp1);
  fce2    = feval(funkce,tmp2);
  chyba   = abs(tmp2 - tmp1);
  while (iterace < max_iter+2) && (chyba > epsilon)
    tmp0     = tmp1;
    tmp1     = tmp2;
    fce0     = fce1;
    fce1     = feval(funkce,tmp1);
    tmp2     = tmp1 - fce1/(fce1-fce0)*(tmp1-tmp0);
    chyba    = abs(tmp2 - tmp1);
    iterace  = iterace + 1;
    pom(iterace) = tmp2;
    pomfce(iterace) = feval(funkce,tmp2);
  end
  pomiter=iterace-1;
  
  xmin=min(pom(1:iterace-1));
  xmax=max(pom(1:iterace-1));
  ymin=min(pomfce(1:iterace-1));
  ymax=max(pomfce(1:iterace-1));
  rozsah_x=(xmax-xmin);   
  rozsah_y=(ymax-ymin);
  xmin=xmin-0.3*rozsah_x;
  xmax=xmax+0.3*rozsah_x;
  ymin=ymin-0.3*rozsah_y;
  ymax=ymax+0.3*rozsah_y;
  axis([xmin xmax ymin ymax]);

  
  plot([xmin xmax],[0 0],'k');
  plot([0 0],[ymin ymax],'k');
  i=0;
  krok=rozsah_x/1000;
  for x=xmin:krok:xmax
    i=i+1;
    y(i)=feval(funkce,x);
  end
  x=xmin:krok:xmax;
  plot(x,y,'b');
% konec pripravy obrazku  


  iterace = 0;
  tmp1    = x0;
  tmp2    = x1;
  fce1    = feval(funkce,tmp1);
  fce2    = feval(funkce,tmp2);
  chyba   = abs(tmp2 - tmp1);

  tisk=sprintf( ... 
  '| iterace |       x(k)       | dx(k)=x(k)-x(k-1) | ');
  disp(tisk)
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end
  disp(retezec);

  tisk=sprintf('| %7.0f | %16.8f |                   |', iterace, tmp1 );
  disp(tisk)
  plot(tmp1,feval(funkce,tmp1),'ro');
  plot([tmp1,tmp1],[0,feval(funkce,tmp1)],'k--');
  pause;
  iterace=iterace+1;
  tisk=sprintf('| %7.0f | %16.8f | %17.8f |', iterace, tmp2, chyba );
  disp(tisk)
  plot(tmp2,feval(funkce,tmp2),'ro');
  plot([tmp2,tmp2],[0,feval(funkce,tmp2)],'k--');
  [~,iminx]=min(pom(1:3));
  [~,imaxx]=max(pom(1:3));
  if pomfce(iminx)<pomfce(imaxx), zn2=-1; else zn2=1; end
  if iminx==3, miny=0; else miny=pomfce(iminx); end
  if imaxx==3, maxy=0; else maxy=pomfce(imaxx); end
  plot([pom(iminx)-(pom(imaxx)-pom(iminx))/5,...
	pom(imaxx)+abs(pom(imaxx)-pom(iminx))/5],...
       [miny+zn2*abs(miny-maxy)/5,...
        maxy-zn2*abs(miny-maxy)/5],'m');
  pause;
  
  while (iterace < max_iter) && (chyba > epsilon)
    tmp0     = tmp1;
    tmp1     = tmp2;
    fce0     = fce1;
    fce1     = feval(funkce,tmp1);
    tmp2     = tmp1 - fce1/(fce1-fce0)*(tmp1-tmp0);
    chyba    = abs(tmp2 - tmp1);
    iterace  = iterace + 1;
    fprintf('| %7.0f | %16.8f | %17.8f |\n', iterace, tmp2, chyba);
    plot(tmp2,feval(funkce,tmp2),'ro');
    plot([tmp2,tmp2],[0,feval(funkce,tmp2)],'k--');
    [~,iminx]=min(pom(iterace:iterace+2));
    [~,imaxx]=max(pom(iterace:iterace+2));
    if iminx==3, miny=0; else miny=pomfce(iminx+iterace-1); end
    if imaxx==3, maxy=0; else maxy=pomfce(imaxx+iterace-1); end
    iminx=iminx+iterace-1;
    imaxx=imaxx+iterace-1;
    if pomfce(iminx)<pomfce(imaxx), zn2=-1; else zn2=1; end
    if iterace<pomiter
    plot([pom(iminx)-(pom(imaxx)-pom(iminx))/5,...
	pom(imaxx)+abs(pom(imaxx)-pom(iminx))/5],...
       [miny+zn2*abs(miny-maxy)/5,...
        maxy-zn2*abs(miny-maxy)/5],'m');
    pause;
    end
  end
  reseni    = tmp2;








