function [reseni, chyba, iterace] = newtonova_metoda(funkce,derivace,x0,epsilon,max_iter);
%Implementace Newtonovy metody pro reseni nelinearni rovnice f(x)=0
%
%	vstupni parametry:
%	funkce			- odkaz na zadanou funkci
%	derivace		- odkaz na derivaci zadane funkce
%	x0			- pocatecni aproximace 
%	epsilon 		- nastaveni pozadovane presnosti 
%	max_iter		- nastaveni maximalniho poctu iteraci 
%
%	vystupni paramery:
%	reseni			- posledni aproximace reseni
%	chyba   		- rozdil dvou po sobe jdoucich aproximaci
%	iterace			- pocet iteracnich kroku metody

clc;
tisk=sprintf('Newtonova metoda pro reseni nelinearni rovnice f(x)=0');
disp(tisk);
tisk=sprintf('pro pocatecni aproximaci x0=%0.8g a zastavovaci podminku |x(k)-x(k-1)|<%0.8g',...
	     x0,epsilon);
disp(tisk);
disp(' ');
tisk=sprintf('Funkce f(x) je zadana v souboru %s.m takto:',funkce);
disp(tisk);
nazev=sprintf('%s.m',funkce);
type(nazev)
disp(' ');
tisk=sprintf('Derivace funkce f(x) je zadana v souboru %s.m takto:',derivace);
disp(tisk);
nazev=sprintf('%s.m',derivace);
type(nazev)

  iterace   = 0;
  tmp2      = x0;
  x         = tmp2;
  chyba     = inf;

  tisk=sprintf( ... 
  '| iterace |       x(k)       | dx(k)=x(k)-x(k-1) | ');
  disp(tisk)
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end;
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end;
  disp(retezec);

  tisk=sprintf('| %7.0f | %16.8f |                   |', iterace, tmp2 );
  disp(tisk)

  while (iterace < max_iter) & (chyba > epsilon)
    tmp1    = tmp2;
    x       = tmp1;
    tmp2    = tmp1 - feval(funkce,x)/feval(derivace,x);
    chyba   = abs(tmp2 - tmp1);
    iterace = iterace + 1;
    disp(sprintf('| %7.0f | %16.8f | %17.8f |', iterace, tmp2, chyba));
  end
  reseni    = tmp2;













