function [reseni, chyba, iterace] = newtonova_metoda_pom(funkce,derivace,x0,epsilon,max_iter)
%Implementace Newtonovy metody pro reseni nelinearni rovnice f(x)=0
%
%	vstupni parametry:
%	funkce			- odkaz na zadanou funkci
%	derivace		- odkaz na derivaci zadane funkce
%	x0			- pocatecni aproximace 
%	epsilon 		- nastaveni pozadovane presnosti 
%	max_iter		- nastaveni maximalniho poctu iteraci 
%
%	vystupni paramery:
%	reseni			- posledni aproximace reseni
%	chyba   		- rozdil dvou po sobe jdoucich aproximaci
%	iterace			- pocet iteracnich kroku metody


  iterace   = 0;
  tmp2      = x0;
  %x         = tmp2;
  chyba     = inf;

  while (iterace < max_iter) && (chyba > epsilon)
    tmp1    = tmp2;
    x       = tmp1;
    tmp2    = tmp1 - feval(funkce,x)/feval(derivace,x);
    chyba   = abs(tmp2 - tmp1);
    iterace = iterace + 1;
  end
  reseni    = tmp2;

