function [x, nm_error, iteraci, H] = gauss_seidel(A, b, x0, tolerantion, max_iter)
% Gauss-Seidelova metoda pro reseni soustavy rovnic Ax=b
%
%	vstupn parametry:
%	A			- matice soustavy
%	b			- vektor prav strany
%	x0			- poten aproximace (vektor)
%	tolerantion		- nastaven poadovan pesnosti (slo)
%	max_iter		- nastaven maximlnho potu iterac (slo)
%
%	vstupn paramery:
%	x			- posledn aproximace een
%	nm_error		- euklidovsk norma rozdlu
%				  dvou po sob jdoucch aproximac
%	iteraci			- poet iteranch krok metody
%

clc;
tisk=sprintf('Gauss-Seidelova metoda pro reseni soustavy  Ax=b, kde ');
disp(tisk);
A
b
x0
	      
  n = size(A,1);
  x=x0;
  iteraci=0;
  nm_error=inf;
  
  D=diag(diag(A));
  L=tril(A)-D;
  U=triu(A)-D;
  H=-(L+D)\U
  g=(L+D)\b
   
  while ((nm_error > tolerantion) && (iteraci < max_iter))
    iteraci=iteraci+1;
    x_new=H*x+g;
    fprintf('%d. iterace = [ %f], rozdl iterac [ %f]\n',iteraci,x_new(1),x_new(1)-x(1));
    for i=2:n
       fprintf('             [ %f],                [%f]\n', x_new(i),x_new(i)-x(i)  );
    end  
    disp(' ');
    nm_error=norm(x_new-x);
    x=x_new;
    pause;
  end

  x


