%-----------------------------------------------------------
%     Geometricke znazorneni Gauss-Seidelovy metody
%-----------------------------------------------------------

clc;
tisk=sprintf('Geometricke znazorneni Gauss-Seidelovy metody');
disp(tisk);
disp(' ');
disp(' ');

a11=9;
a12=2;
a22=3;
b1=48;
b2=26;

A=[a11, a12; a12, a22];
b=[b1;b2];

x0=9;
y0=0;

iteraci=10;
epsilon=0.001;

presne=A\b;

figure(1);
clf;
hold on;
xmin=-1;
xmax=11;
ymin=-5;
ymax=13;
xlim=([xmin xmax]);
ylim=([ymin ymax]);
title('Gauss-Seidelova metoda');
axis([xmin xmax ymin ymax]);
krok=0.01;

pomx=2.6:krok:6.1;
pomy=b1/a12-a11/a12*pomx;
p1=plot(pomx,pomy,'m');
pomx=0:krok:10;
pomy=b2/a22-a12/a22*pomx;
p2=plot(pomx,pomy,'b');

rce1=strcat(int2str(a11),'x+',int2str(a12),'y=',int2str(b1));
rce2=strcat(int2str(a12),'x+',int2str(a22),'y=',int2str(b2));
text(0,-1,rce1);
text(0,-2,rce2);

% Gauss-Seidelova metoda
X=x0;
Y=y0;
x=[X,Y]';
iter=0; 
D=diag(diag(A));
L=tril(A)-D;
U=triu(A)-D;
H=-(L+D)\U;
g=(L+D)\b;
while (iter < iteraci+1)
  iter=iter+1;
  x=H*x+g;
  X=[X,x(1)];
  Y=[Y,x(2)];
end

  tisk=sprintf( ... 
  '| k |   x(k)   |   y(k)   | x(k)-x(k-1) | y(k)-y(k-1) | norma chyby |');
  disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
  iter=0;
  while iter<delka
   retezec=['-',retezec];
   iter=iter+1;
  end
  disp(retezec);
norma=norm(presne-[X(1), Y(1)]');
tisk=sprintf('| 0 |%9.6f |%9.6f |             |             |  %9.6f  |',...
	      X(1), Y(1), norma);
disp(tisk);

for i=1:iteraci
 p3=plot(X(i),Y(i),'ro'); 
 legend([p1 p2 p3],{'1. rovnice','2. rovnice','iterace'})
 pause;
 plot([X(i),X(i+1)],[Y(i),Y(i)],'k--');
 plot(X(i+1),Y(i),'g*'); 
 plot([X(i+1),X(i+1)],[Y(i),Y(i+1)],'k--');
 norma=norm(presne-[X(i+1), Y(i+1)]');
 tisk=sprintf('|%2d |%9.6f |%9.6f |  %9.6f  |  %9.6f  |  %9.6f  |',...
	       i,X(i+1), Y(i+1),X(i+1)-X(i),Y(i+1)-Y(i), norma);
 disp(tisk);
end
plot(X(iteraci),Y(iteraci),'ro'); 
legend([p1 p2 p3],{'1. rovnice','2. rovnice','iterace'})

zoom on;









