%-----------------------------------------------------------
%   Geometricke znazorneni principu gradientnich metod
%-----------------------------------------------------------

clear;
clc;

is_pde=is_toolbox('partial');

if ~is_pde
  disp(' ');
  disp('Lituji, ale neni k dispozici Partial Differential Equation Toolbox !');
  disp(' '); 
else

tisk=sprintf('Geometricke znazorneni principu gradientnich metod');
disp(tisk);
disp(' ');
clf;
clear;

A=[9 2;2 3];
b=[48,26]';
a11=A(1,1);
a12=A(1,2);
a21=A(2,1);
a22=A(2,2);
b1=b(1);
b2=b(2);
res=A\b;
m=res(1);
n=res(2);

krok=0.05;
epsilon=4;
mez=-50;
xmin=-2;
xmax=10;
ymin=-4;
ymax=16;

fi=(atan(2*a12/(a11-a22)))/2;
koef_a=1/(0.5*(a11*cos(fi)^2+2*a12*cos(fi)*sin(fi)+a22*sin(fi)^2))^0.5;
koef_b=1/(0.5*(a11*sin(fi)^2-2*a12*cos(fi)*sin(fi)+a22*cos(fi)^2))^0.5;
koef_c=0.5*a11*m^2+a12*m*n+0.5*a22*n^2-b1*m-b2*n;
const=11.12;
koef_a=koef_a*const;
koef_b=koef_b*const;

%pdeellip(res(1),res(2),koef_a,koef_b,fi,'e');
gd=[4,res(1),res(2),koef_a,koef_b,fi]';
sf='e';
%g=decsg(gd,sf);
g=decsg(gd);

[P,E,T]=initmesh(g);
[P,E,T]=refinemesh(g,P,E,T);
%P=jigglemesh(P,E,T);

figure(1);
clf;
set(figure(1),'Units','centimeters');
set(figure(1),'Position',[20 6 20 20]);
hold on;
rotate3d on;
view(26,32);


T=T(1:3,:);
T=T';
P=P';
FP=zeros(max(size(P)),1);

for i=1:max(size(P))
  FP(i)=0.5*P(i,:)*A*(P(i,:))'-b'*(P(i,:))';
end


obj=trisurf(T,P(:,1),P(:,2),FP);
shading interp;
%colormap(pink);
colormap(copper);

X=9;
Y=0;
plot3(X,Y,hodnotaF(X,Y,A,b),'g*');
plot3(X,Y,hodnotaF(X,Y,A,b),'go');

for t=hodnotaF(X,Y,A,b):-7:-174
  pr=line([X,X],[Y,Y],[t t-4]);
  set(pr,'Color',[0 0 0]);
  set(pr,'LineWidth',2)
end
plot3(X,Y,-180,'g*');
plot3(X,Y,-180,'go');

X=4.85;
Y=-(X-8.5)*0.2;
for t=hodnotaF(X,Y,A,b):-7:-175
  pr=line([X,X],[Y,Y],[t t-4]);
  set(pr,'Color',[0 0 0]);
  set(pr,'LineWidth',2)
end
plot3(X,Y,-180,'g*');
plot3(X,Y,hodnotaF(X,Y,A,b),'g*');
plot3(X,Y,-180,'go');
plot3(X,Y,hodnotaF(X,Y,A,b),'go');
%for pomX=0.3:krok/5:9.4
% for pomY=-(pomX-8.5)*0.2
%    plot3(pomX,pomY,hodnotaF(pomX,pomY,A,b),'k-');
% end;
%end; 
j=1;
for pomX=0.3:krok/5:9.4
  pomY=-(pomX-8.5)*0.2;
  pomZ(j)=hodnotaF(pomX,pomY,A,b);
  j=j+1;
end
pomX=0.3:krok/5:9.4;
pomY=-(pomX-8.5)*0.2;
pr=plot3(pomX,pomY,pomZ,'k-');
set(pr,'Color',[0 0 0]);
set(pr,'LineWidth',1.5)

pr=line([0.3,9.4],[1.64,-.18],[-180 -180]);
set(pr,'Color',[0 0 0]);
set(pr,'LineWidth',2)

end












