function [L,U] = lu_rozklad(A)
% Metoda LU rozkladu pro ctvercovou matici A

n=size(A,1);
U=zeros(n);
L=eye(n);

for j=1:n
    for i=1:j
      pom=0;
      for r=1:i-1
        pom=pom+L(i,r)*U(r,j);
      end
      U(i,j)=A(i,j)-pom;
    end
    for i=j+1:n
      pom=0;
      for s=1:j-1
        pom=pom+L(i,s)*U(s,j);
      end
      L(i,j)=(A(i,j)-pom)/U(j,j);
    end
end
