function omega = optimalni_omega(A)
%  Urceni optimalniho parametru omega pro metodu SOR 
%
%  Vstup:  A ... matice soustavy Ax=b
%
%  (H_J ... iteracni matice pro Jacobiovu metodu)  

     D = diag(diag(A));
     U = triu(A)-D;                              
     L = tril(A)-D;
     H_J = -D\(L+U);                           

     % kvadrat spektralniho polomeru matice H_J
     eig(H_J);
     sr=(max(abs(eig(H_J))))^2;
                      
     if sr > 1 
       disp(' Spektralni polomer je vetsi nez 1 =>');
       disp('   => vypoctene omega nelze pouzit');
     end
     omega = 2/(1+sqrt(1-sr))     









