function [lambda, chyba] = jacobiova_diagonalizace_I(A, epsilon, max_iter)
%
%  Metoda Jacobiovy diagonalizace pro vypocet vlastnich cisel matice A
%            (specialni pripad metody qr-transformace)
%
%                   postupna volba matic rotace

clc;
tisk=sprintf('Metoda Jacobiovy diagonalizace pro vypocet vlastnich cisel matice A');
disp(tisk);
A
disp(' ');

[m,n]=size(A);
if m==n
 if norm(A-A')<0.00001
  
 iterace=0;
 chyba=inf;
 i=0;
 
 zobraz_matici(A);
 title('Puvodni matice A');
 pause;
 
 while (chyba > epsilon) && (iterace < max_iter) 
   if i==n-1, i=0; end
   i=i+1;
   j=i+1;
   while (chyba > epsilon) && (iterace < max_iter) & (j <= m)
     zobraz_matici(A,i,j);
     A=rotace(A,i,j);
     nazev=sprintf('%d. iterace', iterace);
     title(nazev);
     iterace=iterace+1;
     pause;
     chyba=norm(tril(A,-1));
     j=j+1;
   end
 end
 
 zobraz_matici(A);
 nazev=sprintf('%d. iterace', iterace);
 title(nazev);
 lambda=diag(A)

 else
  tisk=sprintf('Matice A neni symetricka !!!');
  disp(tisk);
 end
else
 tisk=sprintf('Matice A neni ctvercova !!!');
 disp(tisk);
end




