function [lambda, chyba] = jacobiova_diagonalizace_II(A, epsilon, max_iter)
%
%  Metoda Jacobiovy diagonalizace pro vypocet vlastnich cisel matice A
%            (specialni pripad metody qr-transformace)
%
%  volba maximalniho prvku v absolutni hodnote pro ziskani matice rotace


clc;
tisk=sprintf('Metoda Jacobiovy diagonalizace pro vypocet vlastnich cisel matice A');
disp(tisk);
A
disp(' ');

[m,n]=size(A);
if m==n
 if norm(A-A')<0.00001

 iterace=0;
 chyba=inf;
 
 zobraz_matici(A);
 title('Puvodni matice A');
 pause;
 while (chyba > epsilon) && (iterace < max_iter)
   [prv1,index1]=max(abs(tril(A,-1)));
   [~,index2]=max(prv1);
   i=index2;
   j=index1(index2);
   zobraz_matici(A,i,j);
   A=rotace(A,i,j);
   nazev=sprintf('%d. iterace', iterace);
   title(nazev);
   iterace=iterace+1;
   pause;
   chyba=norm(tril(A,-1));
 end

 zobraz_matici(A);
 nazev=sprintf('%d. iterace', iterace);
 title(nazev);

 lambda=diag(A)

 else
  tisk=sprintf('Matice A neni symetricka !!!');
  disp(tisk);
 end
else
 tisk=sprintf('Matice A neni ctvercova !!!');
 disp(tisk);
end




