function [lambda, chyba] = metoda_rayleighova_podilu_norm(A, y_0, epsilon, max_iter)
%
% Metoda Rayleighova podilu pro vypocet
% dominantniho vlastniho cisla matice A
% s normovanim vlastniho vektoru v kazde iteraci
%
% y_0      ...  pocatecni aproximace
% epsilon  ...  tolerance pro zastaveni vypoctu
% max_iter ...  maximalni pocet iteraci
%

clc;
tisk=sprintf('Metoda Rayleighova podilu pro vypocet dominantniho vlastniho cisla matice A');
disp(tisk);
tisk=sprintf('s normovanim vlastniho vektoru v kazde iteraci');
disp(tisk);
A
disp(' ');

[m,n]=size(A);

if m==n
 y1=y_0;
 chyba=inf;
 iterace=0;
 lambda_stare=inf;

  tisk=sprintf('| k |');
  for i=1:n
   tisk2=sprintf('   y(%d)_k   |', i);
   tisk=[tisk,tisk2];
  end  
  tisk2=sprintf('|  lambda_k  |');
  tisk=[tisk,tisk2];
  disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
  iter=0;
  while iter<delka
   retezec=['-',retezec];
   iter=iter+1;
  end
  disp(retezec);
  tisk=sprintf('| 0 |');

  for i=1:n
   tisk2=sprintf('  %8.7f |', y1(i));
   tisk=[tisk,tisk2];
  end  
  tisk2=sprintf('|            |');
  tisk=[tisk,tisk2];
  disp(tisk);

 while (chyba > epsilon) && (iterace < max_iter)
   iterace=iterace+1;
   y2=A*y1;
   lambda_nove=(y1'*y2)/(y1'*y1);
   chyba=abs(lambda_nove-lambda_stare);
   lambda_stare=lambda_nove;
   tisk=sprintf('|%2.0d |',iterace);
   for i=1:n
    tisk2=sprintf('  %8.7f |', y2(i));
    tisk=[tisk,tisk2];
   end  
   tisk2=sprintf('|%10.6f  |', lambda_nove);
   tisk=[tisk,tisk2];
   disp(tisk);
   y1=y2/norm(y2,inf);
   tisk=sprintf('|   |');
   for i=1:n
    tisk2=sprintf('  %8.7f |', y1(i));
    tisk=[tisk,tisk2];
   end  
   tisk2=sprintf('|            |');
   tisk=[tisk,tisk2];
   disp(tisk);
 end

 lambda=lambda_nove;
else
 tisk=sprintf('Zadana matice neni ctvercova !!!');
 disp(tisk);
end
