function [lambda, chyba] = mocninna_metoda(A, y_0, epsilon, max_iter)
%
% Mocninna metoda pro vypocet
% dominantniho vlastniho cisla matice A
%
% y_0      ...  pocatecni aproximace
% epsilon  ...  tolerance pro zastaveni vypoctu
% max_iter ...  maximalni pocet iteraci
%

clc;
tisk=sprintf('Mocninna metoda pro vypocet dominantniho vlastniho cisla matice A');
disp(tisk);
A
disp(' ');

[m,n]=size(A);

if m==n
 y1=y_0;
 chyba=inf;
 iterace=0;
 lambda_stare=inf;

  tisk=sprintf('| k |');
  for i=1:n
   tisk2=sprintf('    y(%d)_k    |', i);
   tisk=[tisk,tisk2];
  end 
  tisk2=sprintf('|  lambda_k  |');
  tisk=[tisk,tisk2];
  disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end
  iter=0;
  while iter<delka
   retezec=['-',retezec];
   iter=iter+1;
  end
  disp(retezec);
  tisk=sprintf('| 0 |');
  for i=1:n
   tisk2=sprintf(' %1.6e |', y1(i));
   tisk=[tisk,tisk2];
  end  
  tisk2=sprintf('|            |');
  tisk=[tisk,tisk2];
  disp(tisk);

 while (chyba > epsilon) && (iterace < max_iter)
   iterace=iterace+1;
   y2=A*y1;
   [~,i]=max(abs(y2));
   lambda_nove=y2(i)/y1(i);
   chyba=abs(lambda_nove-lambda_stare);
   lambda_stare=lambda_nove;
   tisk=sprintf('|%2.0d |',iterace);
   for i=1:n
    tisk2=sprintf(' %1.6e |', y2(i));
    tisk=[tisk,tisk2];
   end  
   tisk2=sprintf('| %10.7f |', lambda_nove);
   tisk=[tisk,tisk2];
   disp(tisk);
   y1=y2;
 end

 lambda=lambda_nove;
else
 tisk=sprintf('Zadana matice neni ctvercova !!!');
 disp(tisk);
end
