function B = rotace(A,p,q)
%
%  Vyuzije matici rovinne rotace, 
%  vynuluje prvek v pozici (p,q) 
%  a vysledek zapise do matice B
% 


 [~,n]=size(A);
 B=A;
 r=((A(p,p)-A(q,q))^2+4*A(p,q)^2)^0.5;
 si=sign(A(p,q));
 if si==0, si=1; end
 c=(0.5+(A(p,p)-A(q,q))/2/r)^0.5;
 s=si*(0.5-(A(p,p)-A(q,q))/2/r)^0.5;

 bpp=(A(p,p)+A(q,q)+r)/2;
 bqq=(A(p,p)*A(q,q)-A(p,q)*A(p,q))/bpp;
 for i=1:n
   if i~=p && i~=q
     bip=A(i,p)*c+A(i,q)*s;
     biq=-A(i,p)*s+A(i,q)*c;
     B(i,p)=bip;
     B(i,q)=biq;
     B(p,i)=bip;
     B(q,i)=biq;
   end
 end
 B(p,p)=bpp;
 B(q,q)=bqq;
 B(p,q)=0;
 B(q,p)=0;




