function zobraz_matici(A,p,q)
%
% Zobrazi prvky matice A jako barevne body,
% kde barva odpovida abs. hodnote prvku
% (bila=0, cim sytejsi odstin, tim vetsi hodnota)

[m,n]=size(A);
figure(1)
clf;
hold on;
xmin=0.5;
xmax=n+0.5;
ymin=0.5;
ymax=m+0.5;
xlim([xmin xmax]);
ylim([ymin ymax]);
set(gca,'XTick',1:n);
set(gca,'YTick',1:m);
axis ij
axis image
posun=0.3;
max_A=max(max(abs(A)));
for i=1:m
 for j=1:n
   if exist('p') && exist('q') && j==p && i==q
     color=[1 0.2 0.6];
   else 
     color=[1 1 1]-(abs(A(i,j))/max_A)^0.35*[178 60 34]/255;
   end 
   fill([j-0.5 j+0.5 j+0.5 j-0.5], [i-0.5 i-0.5 i+0.5 i+0.5],color);
   prvek=num2str(A(i,j),'%3.5f');
   text(j-posun,i,prvek);
 end
end 







