function outInfo=afinfo
%
%  AFINFO  pomocna funkce pro SNU.
%
%  vystupem je datova struktura obsahujici seznam
%  demo programu na aproximaci funkce
%
%  Josef Danek

% Initialize demo index number
n=0;

% ===============================================
% Aproximace na okoli bodu
% ===============================================
n=n+1;
afList(n).Name='Aproximace na okolí bodu';
afList(n).Type='Aproximace funkce';
afList(n).Help= {
    ' Danou funkci f=f(x) aproximujeme pomocí Taylorova'
    ' polynomu na malém okolí bodu x0. '
    ' Má-li funkce f v bodě x0 n derivaci, potom požadujeme, aby '
    '  '
    '      phi^(j) (x0) = f^(j) (x0) ,     j=0,1,...,n     '

};
afList(n).DemoList= {
    'Metoda Taylorova polynomu',
    '   Příklad 1'
    '   Příklad 2'
    '   Příklad 3'
    '   Příklad 4'
    '   Příklad 5'
    '   Příklad 6'
};

afList(n).FcnList= {
    '',
    'testuj 4 pr001',
    'testuj 4 pr002',
    'testuj 4 pr003',
    'testuj 4 pr004',
    'testuj 4 pr005',
    'testuj 4 pr006',
};

% ===============================================
% Interpolace
% ===============================================
n=n+1;
afList(n).Name='Aproximace interpolačním polynomem';
afList(n).Type='Aproximace funkce';
afList(n).Help= {...           
  ' Předpokládáme, že máme funkci f=f(x) zadanou tabulkou' 
  ' hodnot v uzlových bodech x0, x1, ... ,xn. '
  ' '
  ' Cílem je danými body proložit polynom P(x) tak, aby'
  ' byly splněny interpolační podmínky:'
  ' '
  '           P(xi) = f(xi) ,     i = 0,1,...,n'
  };
afList(n).DemoList={
   'Lagrangeův interpolační polynom'
    '   Příklad 1'
    '   Příklad 2'
    '   Příklad 3 (bez zadaných dat s vykreslením dílčích polynomů)'
    '   Příklad 4 (bez zadaných dat bez vykreslení dílčích polynomů)'
   'Newtonův interpolační polynom'
    '   Příklad 5'
    '   Příklad 6'
    '   Příklad 7 (bez zadaných dat s vykreslením dílčích polynomů)'
    '   Příklad 8 (bez zadaných dat bez vykreslení dílčích polynomů)'
   'Nevilleův algoritmus'
    '   Příklad 9 (bez geometrického znázornění)'
    '   Příklad 10 (s geometrickým znázorněním)'
    '   Příklad 11 (bez geometrického znázornění)'
    '   Příklad 12 (s geometrickým znázorněním)'
    '   Příklad 13 (s geometrickým znázornením)'
   'Nevýhody použití interpolačního polynomu'
    '   Při extrapolaci'
    '       Příklad I'
    '       Příklad II'
    '   Pro větší počet zadaných bodů'
    '       Příklad I'
    '       Příklad II'
    '   Pro aproximaci funkce, která má asymptotu'
    '       Příklad I'
    '       Příklad II'
    '   Citlivost na vstupní data'
    '       Příklad I - ekvidistantní uzly'
    '       Příklad II - vhodně zvolené neekvidistantní uzly '
    '       Příklad III - porovnaní pro 10 uzlů'
    '       Příklad IV - porovnaní pro 15 uzlů'
   };
afList(n).FcnList={
    '',
    'testuj 4 pr007',
    'testuj 4 pr008',
    'testuj 4 pr009',
    'testuj 4 pr010',
    '',
    'testuj 4 pr011',
    'testuj 4 pr012',
    'testuj 4 pr013',
    'testuj 4 pr014',
    '',
    'testuj 4 pr015',
    'testuj 4 pr016',
    'testuj 4 pr017',
    'testuj 4 pr018',
    'testuj 4 pr019',
    '',
    '',
    'testuj 4 pr020',
    'testuj 4 pr021',
    '',
    'testuj 4 pr022',
    'testuj 4 pr023',
    '',
    'testuj 4 pr024',
    'testuj 4 pr025',
    '',
    'testuj 4 pr026',
    'testuj 4 pr027',
    'testuj 4 pr028',
    'testuj 4 pr029',
   };

% ===============================================
% SPLINE FUNKCE
% ===============================================
n=n+1;
afList(n).Name='Aproximace spline funkcí';
afList(n).Type='Aproximace funkce';
afList(n).Help= {...           
   ' Funkci zadanou tabulkou aproximujeme na každém'
   ' podintervalu   < x(i) , x(i+1) >   polynomem tak,'
   ' aby výsledná složená funkce procházela zadanými body'
   ' a byla spojitá, a v závislosti na stupni polynomu'
   ' měla spojité i derivace až do určitého řádu.'
  };
afList(n).DemoList={
   'Kubický spline'
   '   Příklad 1'
   '   Příklad 2'
   '   Příklad 3'
   '   Příklad 4'
   };
afList(n).FcnList={
    '',
    'testuj 4 pr030',
    'testuj 4 pr031',
    'testuj 4 pr032',
    'testuj 4 pr033',
    };

% ===============================================
% L2-aproximace
% ===============================================
n=n+1;
afList(n).Name='L2-aproximace';
afList(n).Type='Aproximace funkce';
afList(n).Help= {...           
   ' Pro zadanou funkci hledáme aproximaci, pro kterou '
   ' nepožadujeme splnění interpolačních podmínek. '
   ' V diskrétním případě (funkce je dána tabulkou hodnot)'
   ' mohou být zadané hodnoty zatíženy chybou (např. měření).'
   ' Ve třídě zvolených funkcí hledáme tu, která má'
   ' nejmenší souhrnou odchylku od zadaných bodů.' 
  };
afList(n).DemoList={
   'Diskretni L2-aproximace'
   '   Příklad 1 (stupeň 1)'
   '   Příklad 2 (stupeň 1)'
   '   Příklad 3 (stupeň 2)'
   '   Příklad 4 (stupeň 3)'
   '   Příklad 5 (stupeň 4)'
   '   Příklad 6 (všechny stupně)'
   '   Příklad 7 (bez zadaných dat + všechny stupně)'
   'Spojitá L2-aproximace'
   '   Příklad 8 (stupeň 1)'
   '   Příklad 9 (stupeň 2)'
   '   Příklad 10 (0-4 stupeň)'
   '   Příklad 11 (0-optimální stupeň)'
   '   Příklad 12 (0-4 stupeň)'
   '   Příklad 13 (optimální stupeň)'
   '   Příklad 14 (0-4 stupeň)'
   '   Příklad 15 (optimální stupeň)'
    };
afList(n).FcnList={
    '',
    'testuj 4 pr034',
    'testuj 4 pr035',
    'testuj 4 pr036',
    'testuj 4 pr037',
    'testuj 4 pr038',
    'testuj 4 pr039',
    'testuj 4 pr040',
    '',
    'testuj 4 pr041',
    'testuj 4 pr042',
    'testuj 4 pr043',
    'testuj 4 pr044',
    'testuj 4 pr045',
    'testuj 4 pr046',
    'testuj 4 pr047',
    'testuj 4 pr048',
     };

% ===============================================
% FOURIEROVA ANALYZA
% ===============================================
n=n+1;
afList(n).Name='Fourierova analýza';
afList(n).Type='Aproximace funkce';
afList(n).Help= {...           
   ' Pro zadanou periodickou funkci hledáme aproximaci'
   ' (lze jak ve smyslu interpolace, tak ve smyslu '
   ' L2-aproximace) pomocí tzv. trigonometrických '
   ' polynomů.'
  };
afList(n).DemoList={
   'Diskretní Fourierova analýza'
   '   Příklad 1'
   '   Příklad 2'
   '   Příklad 3'
   '   Příklad 4'
   '   Příklad 5'
   '   Příklad 6'
   '   Příklad 7'
   '   Příklad 8'
   '   Příklad 9'
  };
afList(n).FcnList={
    '',
    'testuj 4 pr049',
    'testuj 4 pr050',
    'testuj 4 pr051',
    'testuj 4 pr052',
    'testuj 4 pr053',
    'testuj 4 pr054',
    'testuj 4 pr055',
    'testuj 4 pr056',
    'testuj 4 pr057',
  };


outInfo=afList;



















