function outInfo=derinfo
%
%  DERINFO  pomocna funkce pro SNU.
%
%  vystupem je datova struktura obsahujici seznam
%  demo programu pro vypocet derivace funkce
%
%  Josef Danek

% Initialize demo index number
n=0;

% ===============================================
% Vypocet derivace
% ===============================================
n=n+1;
derList(n).Name='Výpočet derivace';
derList(n).Type='Derivace funkce';
derList(n).Help= {
       ' Vzorce pro výpočet derivace funkce v bodě lze odvodit'
       ' pomocí Taylorova rozvoje nebo obecněji pomocí derivace'
       ' aproximace funkce (interpolačního polynomu).' 
};
derList(n).DemoList= {
    'Základní vzorce',
    '   Příklad 1'
    '   Příklad 2'
};

derList(n).FcnList= {
    '',
    'testuj 5 pr001',
    'testuj 5 pr002',
};
% ===============================================
% Podminenost
% ===============================================
n=n+1;
derList(n).Name='Podmíněnost numerického derivování';
derList(n).Type='Derivace funkce';
derList(n).Help= {
    ' Úloha numerického derivování je špatně podmíněná, tzn., '
    ' že zmenšujeme-li krok h->0, nebude se výsledná aproximace'
    ' derivace funkce v bodě blížit přesné hodnotě.'
};
derList(n).DemoList= {
    'Ukázky podmíněnosti úlohy numerického derivování',
    '   Příklad 1'
    '   Příklad 2'
    '   Příklad 3'
    '   Příklad 4'
};

derList(n).FcnList= {
    '',
    'testuj 5 pr003',
    'testuj 5 pr004',
    'testuj 5 pr005',
    'testuj 5 pr006',
};

% ===============================================
% Richardsonova extrapolace
% ===============================================
n=n+1;
derList(n).Name='Richardsonova extrapolace';
derList(n).Type='Derivace funkce';
derList(n).Help= {
    ' Ke zpřesnění výsledku slouží Richardsonova extrapolace.'
    ' Jedná se o obecný princip využívající znalost rozvoje'
    ' chyby daného vzorce.'
};
derList(n).DemoList= {
    'Ukázky použití Richardsonovy extrapolace',
    '   Příklad 1 (centrální diference)'
    '   Příklad 2 (pravá diference)'
    '   Příklad 3 (levá diference)'
    '   Příklad 4 (pravá diference)'
    '   Příklad 5 (centrální diference)'
    '   Příklad 6 (levá diference)'
    '   Příklad 7 (centrální diference)'
};

derList(n).FcnList= {
    '',
    'testuj 5 pr007',
    'testuj 5 pr008',
    'testuj 5 pr009',
    'testuj 5 pr010',
    'testuj 5 pr011',
    'testuj 5 pr012',
    'testuj 5 pr013',
};

outInfo=derList;



















