function outInfo=intinfo
%
%  INTINFO  pomocna funkce pro SNU.
%
%  vystupem je datova struktura obsahujici seznam
%  demo programu pro reseni soustav linearnich rovnic
%
%  Josef Danek

% Initialize demo index number
n=0;

% ===============================================
% Newtonovy vzorce
% ===============================================
n=n+1;
intList(n).Name='Newtonovy vzorce';
intList(n).Type='Určitý integrál';
intList(n).Help= {
    ' Newtonovy základní vzorce využívají pro výpočet hodnoty '
    ' určitého integrálu ekvidistantní uzly.'
};
intList(n).DemoList= {
    'Výpočet',
    '   Příklad 1'
    '   Příklad 2'
    '   Příklad 3'
    '   Příklad 4'
    '   Příklad 5'
    '   Příklad 6'
};

intList(n).FcnList= {
    '',
    'testuj 6 pr101',
    'testuj 6 pr102',
    'testuj 6 pr103',
    'testuj 6 pr104',
    'testuj 6 pr105',
    'testuj 6 pr106',
};

% ===============================================
% Richardsonova extrapolace
% ===============================================
n=n+1;
intList(n).Name='Richardsonova extrapolace';
intList(n).Type='Určitý integrál';
intList(n).Help= {
    ' Ke zpřesnění výsledku slouží Richardsonova extrapolace.'
    ' Jedná se o obecný princip využívající znalost rozvoje'
    ' chyby daného vzorce.'
};
intList(n).DemoList= {
    'Ukázky použití Richardsonovy extrapolace',
    '   Příklad 1 (lichobězníkové pravidlo)'
    '   Příklad 2 (obdélníkové pravidlo)'
    '   Příklad 3 (Simpsonovo pravidlo)'
    '   Příklad 4 (obdélníkové pravidlo)'
    '   Příklad 5 (lichoběžníkové pravidlo)'
    '   Příklad 6 (Simpsonovo pravidlo)'
};

intList(n).FcnList= {
    '',
    'testuj 6 pr107',
    'testuj 6 pr108',
    'testuj 6 pr109',
    'testuj 6 pr110',
    'testuj 6 pr111',
    'testuj 6 pr112',
};

% ===============================================
% Gaussovy vzorce
% ===============================================
n=n+1;
intList(n).Name='Gaussovy vzorce';
intList(n).Type='Určitý integrál';
intList(n).Help= {
    ' Gaussovy základní kvadraturní vzorce využívají pro výpočet' 
    ' hodnoty určitého integrálu neekvidistantní uzly, které'
    ' jsou vhodně zvoleny tak, aby daný vzorec integroval přesně'
    ' polynom co možná největšího stupně.'
};
intList(n).DemoList= {
    'Výpočet',
    '   Příklad 1'
    '   Příklad 2'
    '   Příklad 3'
    '   Příklad 4'
    '   Příklad 5'
    '   Příklad 6'
    '   Příklad 7'
    '   Příklad 8'
};

intList(n).FcnList= {
    '',
    'testuj 6 pr113',
    'testuj 6 pr114',
    'testuj 6 pr115',
    'testuj 6 pr116',
    'testuj 6 pr117',
    'testuj 6 pr118',
    'testuj 6 pr119',
    'testuj 6 pr120',
};

outInfo=intList;



















