function outInfo=nrinfo
%
%  NRINFO  pomocna funkce pro SNU.
%
%  vystupem je datova struktura obsahujici seznam
%  demo programu pro reseni nelinearnich rovnic
%
%  Josef Danek

% Initialize demo index number
n=0;

% ===============================================
% Startovaci metody
% ===============================================
n=n+1;
nrList(n).Name='Startovací metody';
nrList(n).Type='Nelineární rovnice';
nrList(n).Help= {
	' - vždy konvergentní metody '
        '  '
	' Pro zaručení konvergence předpokládáme pro funkci f:'
        '  * spojitost na uzavřeném intervalu <a,b>'
        '  * f(a).f(b) < 0 '
};
nrList(n).DemoList= {
    'Metoda půlení intervalu',
    '  Příklad 1 '
    '  Příklad 2 '
    '  Příklad 3 '
    'Metoda prosté iterace',
    '  Příklad 4 '
    '  Příklad 5 '
    '  Příklad 6 '
    '  Příklad 7 '
    'Metoda Regula falsi',
    '  Příklad 8 '
    '  Příklad 9 '
};

nrList(n).FcnList= {
    '',
    'testuj 1 pr001',
    'testuj 1 pr002',
    'testuj 1 pr003',
    '',
    'testuj 1 pr004',
    'testuj 1 pr005',
    'testuj 1 pr006',
    'testuj 1 pr007',
    '',
    'testuj 1 pr008',
    'testuj 1 pr009',
};

% ===============================================
% Zpresnujici metody
% ===============================================
n=n+1;
nrList(n).Name='Zpřesňující metody';
nrList(n).Type='Nelineární rovnice';
nrList(n).Help= {...           
   ' metody sloužící k rychlému zpřesnění výsledku získaného' 
   ' pomocí nějaké startovací metody' 
   '  '
   ' (obecně není zaručena konvergence)'
    };
nrList(n).DemoList={
    'Newtonova metoda',
    '  Příklad 1 '
    '  Příklad 2 '
    'Modifikovaná Newtonova metoda',
    '  Příklad 3 '
    '  Příklad 4 '
    'Použití Newtonovy metody pro řešení rovnice v C (fraktál)',
    'Metoda sečen',
    '  Příklad 5 '
    '  Příklad 6 '
};
nrList(n).FcnList={
    '',
    'testuj 1 pr010',
    'testuj 1 pr011',
    '',
    'testuj 1 pr012',
    'testuj 1 pr013',
    'testuj 1 pr014',
    '',
    'testuj 1 pr015',
    'testuj 1 pr016',
    };

% ===============================================
% Soustavy nelinearnich rovnic
% ===============================================
n=n+1;
nrList(n).Name='Soustavy nelineárních rovnic';
nrList(n).Type='Nelineární rovnice';
nrList(n).Help= {...           
   'Modifikované metody pro řešení soustav nelineárních rovnic'
   ' '
   '                      f1(x1,x2,...,xn)=0 '
   '                      f2(x1,x2,...,xn)=0 '
   '                            ... '
   '                      fn(x1,x2,...,xn)=0 '
    };
nrList(n).DemoList={
    'Metoda prosté iterace pro soustavu',
    '  Příklad 1 '
    '  Příklad 2 '
};
nrList(n).FcnList={
    '',
    'testuj 1 pr017',
    'testuj 1 pr018',
    };




outInfo=nrList;



















