function outInfo=slarinfo
%
%  SLARINFO  pomocna funkce pro SNU.
%
%  vystupem je datova struktura obsahujici seznam
%  demo programu pro reseni soustav linearnich rovnic
%
%  Josef Danek

% Initialize demo index number
n=0;

% ===============================================
% Prime metody
% ===============================================
n=n+1;
slarList(n).Name='Přímé metody';
slarList(n).Type='Soustavy lineárních algebraických rovnic';
slarList(n).Help= {
	' Metody, které naleznou přesné řesení po konečně mnoha '
	' krocích. K získání výsledku používají řádkové, resp. '
        ' sloupcové úpravy dané matice.'
};
slarList(n).DemoList= {
    'Gaussova eliminační metoda',
    '   Příklad 1',
    '   Příklad 2',
    'Gaussova eliminační metoda se sloupcovou pivotací',
    '   Příklad 3',
    'Metoda LU-rozkladu',
    '   Příklad 4 (LU-rozklad pro zadanou matici)',
    '   Příklad 5',
};

slarList(n).FcnList= {
    '',
    'testuj 2 pr001',
    'testuj 2 pr002',
    '',
    'testuj 2 pr003',
    '',
    'testuj 2 pr004',
    'testuj 2 pr005',
};

% ===============================================
% Iteracni metody
% ===============================================
n=n+1;
slarList(n).Name='Iterační metody';
slarList(n).Type='Soustavy lineárních algebraických rovnic';
slarList(n).Help= {...           
   ' Metody řešení soustav lineárních rovnic, které pro'
   ' zadané x(0) využívají iterační formuli ve tvaru: '
   '  '
   '                   x(k+1) = H x(k) + g ,    k=0,1,2,... '
   '  '
    };
slarList(n).DemoList={
   'Jacobiova metoda',
   '   Příklad 1',
   'Gauss-Seidelova metoda',
   '   Příklad 2',
   'Relaxační metoda SOR ',
   '   Příklad 3',
   '   Příklad 4',
   '   Příklad 5',
   '   Příklad 6 (Určení optimálního parametru omega)',
   'Speciální případy',
   '   Jacobiova m. konverguje, Gauss-Seidelova m. diverguje',
   '   Jacobiova m. diverguje, Gauss-Seidelova m. konverguje',
   'Geometrický význam metod',
   '   Jacobiova metoda', 
   '   Gauss-Seidelova metoda',
   '   Relaxační metoda SOR (omega < 1) ',
   '   Relaxační metoda SOR (omega > 1) ',
    };
   
slarList(n).FcnList={
    '',
    'testuj 2 pr006',
    '',
    'testuj 2 pr007',
    '',
    'testuj 2 pr008',
    'testuj 2 pr009',
    'testuj 2 pr010',
    'testuj 2 pr011',
    '',
    'testuj 2 pr012',
    'testuj 2 pr013',
    '',
    'testuj 2 pr014',
    'testuj 2 pr015',
    'testuj 2 pr016',
    'testuj 2 pr017',
     };

% ===============================================
% Gradientni metody
% ===============================================
n=n+1;
slarList(n).Name='Gradientní metody';
slarList(n).Type='Soustavy lineárních algebraických rovnic';
slarList(n).Help= {...           
   ' Úloha nalezení řešení soustavy rovnic (se symetrickou,'
   ' pozitivně definitní maticí) je ekvivalentní s úlohou '
   ' nalezení minima energetického funkcionálu '
   ' '
   '     A x = b     <=>     min 1/2 x''Ax - b''x '
    };
slarList(n).DemoList={
   'Princip gradientních metod'
   '   Vrstevnice '
   '   Minimalizace ve směru '
   'Metoda největšího spádu',
   '   Geometrické zobrazení ve 2D '
   '   Geometrickí zobrazení ve 3D '
   '   Příklad s pomalou konvergencí'
   '   Příklad s rychlou konvergencí'
   'Metoda sdružených gradientů'
   '   Geometrické zobrazení ve 2D '
   '   Geometrické zobrazení ve 3D '
    };
slarList(n).FcnList={
    '',
    'testuj 2 pr018',
    'testuj 2 pr019',
    '',
    'testuj 2 pr020',
    'testuj 2 pr021',
    'testuj 2 pr022',
    'testuj 2 pr023',
    '',
    'testuj 2 pr024',
    'testuj 2 pr025',
    };

outInfo=slarList;



















