clc;
disp('----------------------------------------------------------------');
disp(' Zobrazeni souctu cisel A a B v zadane mnozine strojovych cisel ');
disp(' s mantisou delky M a exponentem v rozsahu od Exp_min do Exp_max'); 
disp('----------------------------------------------------------------');
disp(' ');

fprintf(' Zadej cislo  A = ');
A      =input(' ');
fprintf(' Zadej cislo  B = ');
B      =input(' ');
fprintf(' Zadej pocet cisel mantisy  M = ');
M=input(' '); 
fprintf(' Zadej rozsah pro exponent: \n');
fprintf('  Exp_min = ');
Exp_min=input(' ');
fprintf('  Exp_max = ');
Exp_max=input(' ');

[zapisA,qA,nA,obrazA,chybaA]=zobraz_cislo(A,M,Exp_min:Exp_max,0);
[zapisB,qB,nB,obrazB,chybaB]=zobraz_cislo(B,M,Exp_min:Exp_max,0);

[CISLA,P]=stroj_cisla(M,Exp_min:Exp_max,0);
[k,l]=size(CISLA);

figure(1);
clf;

konst1=2.5;
konst2=1.5;
konst3=0.5;

minc=min([P(1),A,obrazA,B,obrazB,A+B]);
maxc=max([P(1),A,obrazA,B,obrazB,A+B]);
pr=(maxc-minc)/20;
p1=plot(P,konst1*ones(size(P)),'ro');
hold on;
p2=plot(A,konst1,'ko');
p3=plot(obrazA,konst1,'go');
plot([minc-pr,maxc+pr],[konst1 konst1 ],'b-');
legend([p1,p2,p3],{'strojova cisla','zadane cislo A','aproximace cisla A'});
set(gca,'YTickLabelMode', 'manual');
set(gca,'YTickLabel', []); 
set(gca,'YLimMode', 'manual'); 
set(gca,'YLim', [0 5]); 

disp('  cislo             zapis obrazu       obraz          ');
disp('------------------------------------------------------------');
disp(sprintf('A=  %f        %s      %f',A, zapisA, obrazA)) ;
pause

clf;
p1=plot(P,konst1*ones(size(P)),'ro');
hold on;
p2=plot(A,konst1,'ko');
p3=plot(obrazA,konst1,'go');
pr=(P(k*l)-P(1))/20;
hold on;
p4=plot(B,konst2,'ks');
p5=plot(obrazB,konst2,'gs');
plot([minc-pr,maxc+pr],[konst2 konst2 ],'b-');
plot([minc-pr,maxc+pr],[konst1 konst1 ],'b-');
plot(P,konst2*ones(size(P)),'ro');
plot(B,konst2,'ks');
plot(obrazB,konst2,'gs');
plot(A,konst1,'ko');
plot(obrazA,konst1,'go');
legend([p1,p2,p3,p4,p5],{'strojova cisla','zadane cislo A','aproximace cisla A',...
        'zadane cislo B','aproximace cisla B'});
set(gca,'YTickLabelMode', 'manual');
set(gca,'YTickLabel', []); 
set(gca,'YLimMode', 'manual'); 
set(gca,'YLim', [0 5]); 
disp(sprintf('B=  %f        %s      %f',B, zapisB, obrazB)) ;

pause;
clf;
p1=plot(P,konst1*ones(size(P)),'ro');
hold on;
p2=plot(A,konst1,'ko');
p3=plot(obrazA,konst1,'go');
pr=(P(k*l)-P(1))/20;
hold on;
p4=plot(B,konst2,'ks');
p5=plot(obrazB,konst2,'gs');
p6=plot(A+B,konst3,'k*');
p7=plot(obrazA+obrazB,konst3,'g*');
[zapisoA_oB,q,n,obraz,chyba]=zobraz_cislo(obrazA+obrazB,M,Exp_min:Exp_max,0);
p8=plot(obraz,konst3,'m*');
[zapisA_B,q,n,obrazsouctu,chyba]=zobraz_cislo(A+B,M,Exp_min:Exp_max,0);
p9=plot(obrazsouctu,konst3,'bs');
plot([minc-pr,maxc+pr],[konst3 konst3 ],'b-');
plot([minc-pr,maxc+pr],[konst2 konst2 ],'b-');
plot([minc-pr,maxc+pr],[konst1 konst1 ],'b-');
plot(P,konst2*ones(size(P)),'ro');
plot(P,konst3*ones(size(P)),'ro');
plot(B,konst2,'ks');
plot(obrazB,konst2,'gs');
plot(A+B,konst3,'k*');
plot(obrazA+obrazB,konst3,'g*');
[zapis,q,n,obraz,chyba]=zobraz_cislo(obrazA+obrazB,M,Exp_min:Exp_max,0);
plot(obraz,konst3,'m*');
[zapis,q,n,obrazsouctu,chyba]=zobraz_cislo(A+B,M,Exp_min:Exp_max,0);
plot(obrazsouctu,konst3,'bs');
legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],{'strojova cisla','zadane cislo A','aproximace cisla A',...
        'zadane cislo B','aproximace cisla B','soucet A+B',...
        'soucet obrazA + obrazB', 'obraz souctu obrazu A a B',...
        'obraz presneho souctu A+B'}  );
set(gca,'YTickLabelMode', 'manual');
set(gca,'YTickLabel', []); 
set(gca,'YLimMode', 'manual'); 
set(gca,'YLim', [0 5]); 
disp('obrazA+obrazB=');
%disp(sprintf('%f+%f=',obrazA,obrazB)); 
disp(sprintf('    %f        %s      %f',obrazA+obrazB, zapisoA_oB, obraz)) ;
pause;
disp(sprintf('A+B=%f        %s      %f',A+B, zapisA_B, obrazsouctu)) ;
disp(' ');
