function [zapis,q,n,obraz,chyba]=zobraz_cislo(cislo_10,cisel_mantisy,exponent,zobraz);
%
% prevede zadane cislo z desitkove soustavy  
% do mnoziny strojovych cisel s danymi vlastnostmi,
% pokud je cislo presne mezi dvema hodnotami, 
% pouzije tu vyssi, jinak vzdy tu blizsi
% zapis ... zapis obrazu zadaneho cisla (string)
% q     ... mantisa
% n     ... hodnota exponentu
% obraz ... strojove cislo, na ktere se zobrazi zadane cislo 
% chyba ... rozdil zadaneho cisla a jeho obrazu

[A,P]=stroj_cisla(cisel_mantisy,exponent,0);
[k,l]=size(A);
obraz=min(abs(P-cislo_10));
index=find((P-cislo_10)==obraz);
if isempty(index)
   index=find((P-cislo_10)==-obraz);
end;
obraz=P(index);
chyba=cislo_10-obraz;

index_zakladu=mod(index,l);
if index_zakladu==0 
  index_zakladu=l; 
end;

index_exponentu=round((index-index_zakladu)/k+1);
if index_exponentu>length(exponent)
   index_exponentu=length(exponent);
end;

n=exponent(index_exponentu);

q=dec2bin(index_zakladu-1);
for j=1:cisel_mantisy-length(q)-1
 q=strcat('0',q);
end;
q=strcat('0.1',q);
zapis=strcat(q,' x 2^',num2str(n));

if zobraz==1
  figure(1);
  clf;
  p1=plot(P,zeros(size(P)),'ro');
  minc=min([P(1),cislo_10,obraz]);
  maxc=max([P(1),cislo_10,obraz]);
  pr=(maxc-minc)/20;
  hold on;
  set(gcf,'Visible', 'on');
  p2=plot(cislo_10,0,'ko');
  p3=plot(obraz,0,'go');
  plot([minc-pr,maxc+pr],[0 0],'b-');
  legend([p1,p2,p3],{'strojova cisla','zadane cislo','aproximace zadaneho cisla'});
  set(gca,'YTickLabelMode', 'manual');
  set(gca,'YTickLabel', []); 
  set(gca,'YLimMode', 'manual'); 
  set(gca,'YLim', [-.5 1]); 
end; 
