function [reseni, pocet_kroku, rozdil_iteraci, konverguje, odhad, q] = ...
         odhad_chyby_proste_iterace(funkce_phi,a,b,x0,epsilon,max_pocet_kroku);

% resime rovnici f(x)=0 na intervalu <a,b>
% pouzijeme prepis  x=funkce_phi(x)
% pocatecni aproximace  x0 
% zastavovaci podminka  |x_(k+1) - x_(k)| < epsilon 
% maximalni pocet kroku  max_pocet_kroku


clc;
disp('Odhad chyby metody proste iterace pro reseni nelinearni rovnice');
tisk=sprintf('       x = phi(x) = %s',funkce_phi);
disp(tisk);
tisk=sprintf('pro pocatecni aproximaci x0=%0.8g a zastavovaci podminku |x(k)-x(k-1)|<%0.8g',...
	     x0,epsilon);
disp(tisk);
disp(' ');
%tisk=sprintf('Funkce funkce_phi(x)=%s',funkce_phi) 

is_symbolic=is_toolbox('symbolic');

if ~is_symbolic
  clc;
  disp(' ');
  disp('Lituji, ale neni k dispozici Symbolic Math Toolbox !');
  disp(' ');
else

figure(1);
clf;
hold on;
zoom on;
set(gcf,'Visible', 'on');

krok=(b-a)/1000;
ymin=inf;
ymax=-inf;

for x=a:krok:b
  phi_x=eval(funkce_phi);
%  phi_x=feval(funkce_phi,x);
  if phi_x>ymax
    ymax=phi_x;
  end;
  if phi_x<ymin
    ymin=phi_x;
  end;
  if x>ymax
    ymax=x;
  end;
  if x<ymin
    ymin=x;
  end;
end;
sx=b-a;
sy=ymax-ymin;
axis([a-0.05*sx b+0.05*sx ymin-0.05*sy ymax+0.05*sy]);

i=0;
for x=a:krok:b
  i=i+1;
%  y(i)=feval(funkce_phi,x);
  y(i)=eval(funkce_phi);  
end;
x=a:krok:b;
plot(x,y,'b');
plot([a-0.05*sx,b+0.05*sx],[0,0],'k');
plot([0,0],[ymin-0.05*sy,ymax+0.05*sy],'k');
plot([a,b],[a,b],'m-');
%phi_a=feval(funkce_phi,a);
x=a;
phi_a=eval(funkce_phi);
%phi_b=feval(funkce_phi,b);
x=b;
phi_b=eval(funkce_phi);
plot([a,a],[0,phi_a],'k--');
plot([b,b],[0,phi_b],'k--');

info=0;
konverguje=1;
pocet_kroku=0;
x_new=x0;
dx_new=inf;

  tisk=sprintf( ... 
  '| krok |       x(k)       | dx(k)=x(k)-x(k-1) |   dx(k)/dx(k-1)   | ');
    disp(tisk);
  delka=length(tisk);
  retezec='';
  if (delka>80), delka=80; end;
   iter=0;
   while iter<delka
    retezec=['-',retezec];
    iter=iter+1;
   end;
   disp(retezec);
  
%phi_x_new=feval(funkce_phi,x_new);
x=x_new;
phi_x_new=eval(funkce_phi);
plot([x_new,x_new],[0,phi_x_new],'k--');
while (abs(dx_new)>epsilon) & (pocet_kroku<max_pocet_kroku)
  if pocet_kroku==0
     tisk=sprintf('| %4.0f |    %9.6f     |                   |                   |',... 
	          pocet_kroku, x_new);
  else 
    if pocet_kroku==1
      tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |                   |',... 
	          pocet_kroku, x_new, dx_new);
    else  
      tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |     %9.6f     |',... 
	           pocet_kroku, x_new, dx_new, dx_new/dx_old);
    end;  
  end;    
  disp(tisk);
  pause;
  x_old=x_new;
%  x_new=feval(funkce_phi,x_new);
  x=x_new;
  x_new=eval(funkce_phi);
  plot([x_new,x_old],[x_new,x_new],'k--');
  plot([x_new,x_new],[0,x_new],'k--');
  plot([x_old,x_old],[0,x_new],'k--');
  dx_old=dx_new;
  dx_new=x_new-x_old;
  pocet_kroku=pocet_kroku+1;
  if abs(dx_new/dx_old)>1
    konverguje=0;
  end;  
end;
tisk=sprintf('| %4.0f |    %9.6f     |     %9.6f     |     %9.6f     |',... 
	      pocet_kroku, x_new, dx_new, dx_new/dx_old);
disp(tisk);
reseni=x_new; 

rozdil_iteraci=abs(dx_new);

% Odhad chyby
x=sym('x');

if verzematlabu==0
 % verze do 2017a
 funkce_phi=sym(funkce_phi);
 derivace=diff(funkce_phi,x);
else
 % verze od 2017b
 derivace=diff(str2sym(funkce_phi),x);
end;

eval(sprintf('[x fval]=fminbnd(@(x) -abs(%s), %f, %f);',char(derivace),a,b));
max_derivace=abs(fval);
q=max_derivace;

if pocet_kroku<max_pocet_kroku
 if max_derivace<1
   odhad=max_derivace/(1-max_derivace)*rozdil_iteraci;
 else
   odhad=inf;
 end;
else
 if max_derivace<1
   odhad=max_derivace/(1-max_derivace)*rozdil_iteraci;
 else
   odhad=inf;
 end;
end; 
end;




