function out=model_komplex(x0,c,n,pohyb,spoj,tiskni);
% pouziva iteracni formuli
% x(n+1)=x(n)^2+c; 

cas=0.05;
if ~exist('pohyb') 
  pohyb=0;
end;

if ~exist('spoj') 
  spoj=0;
end;

figure(1);
clf;
hold on;
axis equal;

T(1)=x0;   

plot(real(T(1)),imag(T(1)),'k*')
pause;

for j=2:n
  T(j)=T(j-1)^2+c;
  if ~pohyb
    plot(real(T(j)),imag(T(j)),'r*');
  else
    plot(real(T(j)),imag(T(j)),'wo')
  end;
end;

if ~pohyb
 plot(real(T(n)),imag(T(n)),'c*')
end;

out=T; 

  Name_real_c=sprintf('%0.10g',real(c));
  Name_imag_c=sprintf('%0.10g',imag(c));
  if imag(c)>=0
    Name_c=strcat('c=',Name_real_c,'+',Name_imag_c,'*i');
  else 
    Name_c=strcat('c=',Name_real_c,Name_imag_c,'*i');
  end;

  max_x=max(max(real(T)),max(real(T)));
  max_y=max(max(imag(T)),max(imag(T)));
  min_x=min(min(real(T)),min(real(T)));
  min_y=min(min(imag(T)),min(imag(T)));
  s_x=min_x+0.05*(max_x-min_x);  
  s_y=min_y+1.05*(max_y-min_y);  
  text(s_x,s_y,strcat(Name_c));

if pohyb
 pause(cas);
 plot(real(T(2)),imag(T(j)),'k*');
 if spoj==1
  plot([real(T(1)),real(T(2))],[imag(T(1)),imag(T(2))],'b-');
 end;
 for j=2:n
   pause(cas);
   plot(real(T(j-1)),imag(T(j-1)),'r*');
   plot(real(T(j)),imag(T(j)),'c*');
   if spoj==1
    plot([real(T(j-1)),real(T(j))],[imag(T(j-1)),imag(T(j))],'b-');
   end;
 end; 
end;

if ~exist('tiskni')
  tiskni=0;
end;

if tiskni
  Name_real_c=sprintf('%0.10g',real(c));
  Name_imag_c=sprintf('%0.10g',imag(c));
  if imag(c)>=0
   Name_c=strcat('c=',Name_real_c,'+',Name_imag_c,'*i');
  else 
   Name_c=strcat('c=',Name_real_c,Name_imag_c,'*i');
  end;
  eval(sprintf('print -depsc2  model_komplex_%s.eps;',Name_c));
end;

