function test_oscilace(bmin,bmax,krok,tol);

sym('X');
sym('Y');
sym('b');

X='b*Y*(10^4-Y)/10^4';
Y='b*X*(10^4-X)/10^4';

rovnice='X-b*(b*X*(10^4-X)/10^4)*(10^4-(b*X*(10^4-X)/10^4))/10^4'
clear X;
sym('X');
 
figure(10);
clf
hold on;

for hodnota_b=bmin:krok:bmax
 rovnice_2=strcat('b-',num2str(hodnota_b));
 reseni=solve(rovnice,rovnice_2);
 koreny=reseni.X;
 vec_ind=[];
 for j=1:4
   if isreal(koreny(j))
     vec_ind=[vec_ind j];
   end;
 end; 
 koreny=koreny(vec_ind);

 if koreny(1)=='0.'
   koreny=koreny(2:length(koreny));
 end;

 if koreny(1)=='0'
  koreny=koreny(2:length(koreny));
 end;

 vec_ind=[];
 for i=1:length(koreny)
  if abs(eval(koreny(i))-10000*(1-1/hodnota_b))>tol;
   vec_ind=[vec_ind i];
  end;
 end;
 if isempty(vec_ind)
   vec_ind=1;
 end;
 vysledek=koreny(vec_ind);

 for i=1:length(vysledek)
  figure(10);
  plot(hodnota_b,eval(vysledek(i)),'b.');
 end;
end;
