function z28(bb);

if exist('bb')~=1
  bb=3.2;
end;

clc;
disp(' Zkoumame, mezi kterymi 2 hodnotami osciluje reseni ');
disp(' v modelu rustu populace s omezenim:');
disp(' ');
disp(' MEZ     = 10000  ');
disp(' x_0     = 1000   ');
disp(' x_(n+1) = b * x_(n) *(MEZ - x_(n)) / MEZ');
disp(sprintf(' b       = %f', bb));
disp(' ');

syms b po_substituci;
X='b*Y*(10^4-Y)/10^4';
Y='b*X*(10^4-X)/10^4';

disp('Predpokladame, ze ');
disp('- liche cleny posloupnosti se ustali na hodnote X');
disp('- sude cleny posloupnosti se ustali na hodnote Y');
disp(' ');
pause
disp('Limitne tedy musi platit, ze ');
disp(sprintf('  X = %s ',X));
disp(sprintf('  Y = %s ',Y));
disp(' ');
pause

if verzematlabu==0
 % verze do 2017a
 X=sym(X);
 Y=sym(Y);
else
 % verze od 2017b
 X=str2sym(X);
 Y=str2sym(Y);
end;

%%% subs('b*Y*(10^4-Y)/10^4','Y','b*X*(10^4-X)/10^4')
%%eval(sprintf('po_substituci=subs(''%s'',''%s'',''%s'');', po_substituci, 'Y', Y)); 
%po_substituci=b*(b*X*(10^4-X)/10^4)*(10^4-(b*X*(10^4-X)/10^4))/10^4;
po_substituci=b*Y*(10^4-Y)/10^4;

disp('Po dosazeni za Y do prvni rovnice dostaneme rovnici ');
disp(sprintf('  X = %s ',char(po_substituci)));
pause
%disp('resp. po faktorizaci')
disp(' ');
disp('resp. ')

if verzematlabu==0
 % verze do 2017a
 rovnice=sym(['X-',char(po_substituci)]);
 eval(sprintf('reseni=solve(rovnice,''b-%f'');',bb));
else
 % verze od 2017b
 rovnice=str2sym(['X-',char(po_substituci)]);
 reseni=solve(rovnice,b-bb);
end;

disp(sprintf('  0 = %s ',char(rovnice)));
%disp(' 0 = ');
%pretty(factor(rovnice));
disp(' ');
pause

disp(sprintf('Reseni pro parametr b=%f jsou',bb));
disp(' ');

koreny=eval(reseni.X);
for i=1:length(koreny)
  if isreal(koreny(i))
   disp(sprintf('  X(%d) = %f',i,koreny(i)));
  else
   znamenko='+';
   if sign(imag(koreny(i)))<0
    znamenko='-';
   end;  
   disp(sprintf('  X(%d) = %f %s %f * i',i,real(koreny(i)),znamenko,abs(imag(koreny(i)))));
  end;
end;
disp(' ');

if isreal(koreny(3))==0
 disp(' Koreny X(3) a X(4) nejsou realne. =>');
 disp(' V tomto pripade nebude reseni oscilovat mezi dvema hodnotami.');  
end;
disp(' ');

pause
disp('Pro overeni vypiseme nasledujici iterace:')
disp(' ');
it=30;
tabulka=model_populace(1000,bb,10000,it);
for i=it-3:it
   disp(sprintf('  X_%d = %f',i,tabulka(i)));
end;
