function zivot(A,p,q,N,prodleva);

% trivialni podoba hry ZIVOT
% A ... zadana binarni matice 
%        1 ... ziva bunka
%        0 ... mrtva bunka
% okoli bunky [i,j]:
%       [i+1,j-1] [i+1, j] [i+1,j+1]               
%       [i  ,j-1] [i  , j] [i  ,j+1]               
%       [i-1,j-1] [i-1, j] [i-1,j+1]               
%       
% p ... min pocet bunek v okoli pro zachovani zivota
% q ... max pocet bunek v okoli pro zachovani zivota
% N ... max pocet iteraci 
% prodleva ... cas v sekundach pro zobrazeni 1 kroku  
  
clc;
tisk=sprintf('Hra Zivot');
disp(tisk);
disp('-----------------------------------------------------');

if exist('A')~=1
  A = (randi(5,20,20) - 4)>0;
end;

if (exist('p')==1 & exist('q')==1)
  tisk=sprintf(' Min. pocet bunek v okoli pro udrzeni zivota   p=%1g', p);
  disp(tisk);
  tisk=sprintf(' Max. pocet bunek v okoli pro udrzeni zivota   q=%1g', q);
  disp(tisk);
else
  fprintf(' Zadej min. pocet bunek v okoli pro udrzeni zivota   p = ');
  p=input(' ');   
  fprintf(' Zadej max. pocet bunek v okoli pro udrzeni zivota   q = ');
  q=input(' ');   
 end;

if exist('N')~=1 
 N=50;
 prodleva=0.1;
end;

[m,n]=size(A);
zobraz_matici(A);
title('Puvodni matice A');
pause;
i=1;

while (nnz(A)>0) & (i <= N) 
  pomA=zeros(m+2,n+2);
  pomA(2:m+1,2:n+1)=A(:,:);  
  B=zeros(m,n);
  for k=2:m+1
    for l=2:n+1    
      x=nnz(pomA(k-1:k+1,l-1:l+1)); %-abs(sign(pomA(k,l)));
      if (x>=p)&(x<=q)  
	B(k-1,l-1)=1; 
      else
        B(k-1,l-1)=0;
      end;
    end;
  end;
  A=B;
  zobraz_matici(A);
  nazev=sprintf('%d. iterace', i);
  title(nazev);
  if exist('prodleva')
    pause(prodleva);
  else
    pause;
  end;
  i=i+1;
end;



