function out=julia_set(min_re,max_re,min_im,max_im,krok_re,krok_im,c,max_pocet_iteraci,tiskni);

x=min_re:krok_re:max_re;
y=min_im:krok_im:max_im;
Z=zeros(length(x),length(y));
i=sqrt(-1);

figure(1);
clf;
hold on;
axis equal;
axis off;

for l=1:length(x);
  for k=1:length(y);
    konec=1;
    z1=x(l);
    z2=y(k);
    z=z1+i*z2;
    while konec>0
      zn=z^(2)+c;
      konec=konec+1;
      if abs(z)>2
        konec=-konec;     
      end;
      if konec>max_pocet_iteraci;
        konec=0;
      end;
      z=zn;
    end;
    Z(l,k)=-konec;
  end;
end;

%[xx,yy]=meshgrid(x,y);
imagesc(x,y,Z'); %'
out=Z';
shading interp;
colormap(hot);

popis=strcat('Juliova mnozina pro   c=',num2str(c));
text(min_re,max_im+0.05*(max_im-min_im),popis);

if ~exist('tiskni')
  tiskni=0;
end;

if tiskni
  Name1=sprintf('%0.4g',min_re);
  Name2=sprintf('%0.4g',max_re);
  Name3=sprintf('%0.4g',min_im);
  Name4=sprintf('%0.4g',max_im);
  Name5=num2str(c);
  eval(sprintf('print -depsc2  Julia_%s_%s_%s_%s_%s.eps;',Name1,Name2,Name3,Name4,Name5));
end;


