
clc;

disp('                 Hamminguv kod ');
disp('-------------------------------------------------');
disp(' ');
disp(' Uvazujeme tzv. hypergraf Fanovy roviny, ktery ma');
disp(' 7 vrcholu a 7 hran - kazda hrana spojuje 3 body.');

hypergraf;
pause;
disp(' ');
disp(' Body:  1, 2, 3, 4, 5, 6, 7 ');
disp(' Hrany: (1,2,4), (1,3,7), (1,5,6), (2,3,5),');
disp('        (2,6,7), (3,4,6), (4,5,7)');
disp(' ');
pause
disp(' Kazde hrane priradime charakteristicky vektor:');

v=[1 2 4; 1 3 7; 1 5 6; 2 3 5; 2 6 7; 3 4 6; 4 5 7];

delka=length(v);
for i=1:delka
     index(2*i-1)= 2^(delka-v(i,1)) + 2^(delka-v(i,2)) + 2^(delka-v(i,3));  
     index(2*i)=127-index(2*i-1);
end;
index(2*delka+1)=0;
index(2*delka+2)=2^delka-1;

kod=dec2bin(index);

for i=1:7
  pause;
  disp(sprintf('  (%d,%d,%d)   ->   %s',...
	       v(i,1), v(i,2), v(i,3), kod(2*i-1,:))); 
end;
pause;
disp(' ');
disp(' K charakteristickym vektorum doplnime jejich doplnky:');

for i=1:7
  pause;
  disp(sprintf('                 %s  ->  %s',...
	       kod(2*i-1,:), kod(2*i,:))); 
end;
pause;
disp(' ');
disp(' Dale pridame vektory:');
disp(sprintf('                 %s  ->  %s',...
	       kod(15,:), kod(16,:))); 

pause;
disp(' ');
disp(' Techto 16 vektoru ma zajimavou vlastnost -');
pause;
disp(' 2 vektory se lisi bud ve 3, 4 nebo 7 pozicich');
pause;
disp(' ');
disp(' Overeni: ');
disp(' ');
pause;

for i=1:2*delka+1
 for j=i+1:2*delka+2
   p1=kod(i,:);        
   p2=kod(j,:);
   rozdily=nnz(p1~=p2);
   disp(sprintf(' %s  %s  %d  ',p1,p2,rozdily));   
   pause;
 end;
end;

pause;
disp(' ');
disp(' V Hammingove kodu se vyuziva techto 16 vektoru.');
disp(' Zprava je prevedena do binarni podoby a rozdelena');
disp(' na ctverice bitu. Ke kazde ctverici existuje prave');
disp(' jeden vektor z techto 16, ktery obsahuje na zacatku');
disp(' tuto ctverici. ');
disp(' ');
disp(' Misto, aby se posilaly pouze ctverice, posilaji se');
disp(' prislusne sedmibitove vektory.');
disp(' Pokud nastane chyba v jednom bitu, lze ji opravit!');


