function hypergraf;

figure(10);
clf;
axis equal;
axis off;
set(gca,'XTick',[]); 
set(gca,'YTick',[]); 
set(gcf,'Name',' Hypergraf Fanovy roviny');
hold on;

plot(0,9.3,'g');
body=[-5, 0; 0, 0; 0, sqrt(3)/3*5; 5, 0; 0, sqrt(3)*5; -2.5, sqrt(3)*2.5; 2.5, sqrt(3)*2.5];
plot(body([1,4,5,1],1),body([1,4,5,1],2),'b-');
plot(body([1,7],1),body([1,7],2),'b-');
plot(body([4,6],1),body([4,6],2),'b-');
plot(body([2,5],1),body([2,5],2),'b-');
index=0;
for i=0:pi/180:2*pi
  index=index+1;
  c(index,1:2)=[body(3,2)*cos(i), body(3,2)*(1+sin(i))];
end;
plot(c(:,1),c(:,2),'b-');
plot(body(:,1),body(:,2),'ro');


for i=1:length(body)
  pom=0.12*(body(i,:)-body(5,:)./2)*((norm(body(i,:)-body(5,:)./2)))^(1/1e6);
  if i==3
    pom=[0.2 -0.4];
  end;
  popis=num2str(i);
  text(body(i,1)+pom(1)-0.1,body(i,2)+pom(2),popis);
end; 
