function testovani_duplicitnich_zprav(n,m,p,opakovani);

clc;
disp('         Testovani posilani duplicitnich zprav          ');
disp('-------------------------------------------------------');

if exist('n')==1 & exist('m')==1 & exist('p')==1 & exist('opakovani')==1
 if m>0
  disp(sprintf(' Puvodni zprava ma %d bitu.',n));
  disp(sprintf(' Kazdy bit zpravy je poslan %d krat za sebou.',opakovani));
  disp(sprintf(' Pravdepodobnost chyby pri prenosu jednoho bitu je %f.',p));    
  disp(sprintf(' Pri testovani cely proces opakujeme %d krat.',m));
 end;
else
  disp(' Puvodni zprava ma n bitu.');
  disp(' Kazdy bit zpravy je poslan o krat za sebou.');
  disp(' Pravdepodobnost chyby pri prenosu jednoho bitu je p.');    
  disp(' Pri testovani cely proces opakujeme m krat.');
  disp(' ');
  fprintf(' Zadej delku zpravy     n = '); 
  n=input(' ');
  opakovani=0;
  while fix(opakovani/2)==opakovani/2
   fprintf(' Zadej, kolikrat duplikujeme kazdy bit  o = ');    
   opakovani=input(' ');  
   if fix(opakovani/2)==opakovani/2
     disp(' Pocet opakovani bitu musi byt liche cislo!');
   end; 
  end;
  fprintf(' Zadej pravdepodobnost chyby v 1 bitu   p = ');
  p=input(' ');
  fprintf(' Zadej pocet opakovani pro testovani    m = ');
  m=input(' ');
end;

if m>0
zprava='';
for i=1:n
  zprava=strcat(zprava,num2str(1));
end;

celkovy_pocet_chyb=0;
pocet_bezchybnych_prenosu=0;
for j=1:m
  [prijato,pocet_chyb]=zprava_duplikovana(zprava,opakovani,p);
  celkovy_pocet_chyb=celkovy_pocet_chyb+pocet_chyb;
  if pocet_chyb==0
    pocet_bezchybnych_prenosu=pocet_bezchybnych_prenosu+1;
  end;
end;

disp(' ');
disp(sprintf(' Prumerny pocet chyb pri prenosu jedne zpravy je %f',...
	     celkovy_pocet_chyb/m));
disp(sprintf(' Z %d prenosu bylo %d bezchybnych,',...
             m,pocet_bezchybnych_prenosu));
disp(sprintf(' tj. %2.1f procent prenosu bylo bezchybnych.',...
             100*pocet_bezchybnych_prenosu/m));
disp(' ');
disp('-------------------------------------------------------');
pause
end;

disp(' Teoreticky plati, ze pri posilani zpravy o n bitech,    ');
disp(' s pravdepodobnosti chyby pri prenosu 1 bitu p, pricemz  ');
disp(' kazdy bit posilame o krat, je pravdepodobnost bezchybneho');
disp(' prenosu opakovane poslaneho bitu dano souctem:    ');
disp(' ');
pravdepodobnost_bezchybneho_prenosu=(1-p)^opakovani;
disp('  (1-p)^o  ...  v o-tici zadna chyba');
disp(sprintf('    = (1-%f)^%d = %f',p,opakovani,(1-p)^opakovani));
pause;
for j=1:fix(opakovani/2)
 disp(' '); 
 disp(sprintf('  (o nad %d) p^%d (1-p)^(o-%d)  ...   v o-tici %d chyb',...
	      j,j,j,j));
 pomoc=kombinacni_cislo(opakovani,j);
 pomoc=pomoc*p^j*(1-p)^(opakovani-j);
 pravdepodobnost_bezchybneho_prenosu=...
   pravdepodobnost_bezchybneho_prenosu+pomoc;
 disp(sprintf('    = (%d nad %d) %f^%d (1-%f)^(%d-%d) = %f',...
              opakovani,j,p,j,p,opakovani,j,pomoc));     
 pause;
end;
disp(' ');
disp(sprintf(' v souctu pro jeden bit:  %f ', pravdepodobnost_bezchybneho_prenosu ));

disp(' ');
disp(' Pravdepodobnost bezchybneho prenosu cele zpravy:    ');
disp(' ');

disp(sprintf(' %f^n = %f^%d = %f', pravdepodobnost_bezchybneho_prenosu,...
	     pravdepodobnost_bezchybneho_prenosu,n,...
             pravdepodobnost_bezchybneho_prenosu^n));


