function testovani_kodovanych_zprav(n,m,p);

clc;
disp('         Testovani posilani kodovanych zprav           ');
disp('-------------------------------------------------------');

if exist('n')==1 & exist('m')==1 & exist('p')==1 
 if m>0
  disp(sprintf(' Puvodni zprava ma %d bitu.',n));
  disp(sprintf(' Pravdepodobnost chyby pri prenosu jednoho bitu je %f.',p));    
  disp(sprintf(' Pri testovani cely proces opakujeme %d krat.',m));
 end;
else
  disp(' Puvodni zprava ma n bitu.');
  disp(' Pravdepodobnost chyby pri prenosu jednoho bitu je p.');    
  disp(' Pri testovani cely proces opakujeme m krat.');
  disp(' ');
  fprintf(' Zadej delku zpravy (delitelna 4)       n = '); 
  n=input(' ');
  if mod(n,4)~=0
    n=ceil(n/4)*4;
   disp(sprintf('  Delka puvodni zpravy upravena na n = %d bitu.',n));
  end;
  fprintf(' Zadej pravdepodobnost chyby v 1 bitu   p = ');
  p=input(' ');
  fprintf(' Zadej pocet opakovani pro testovani    m = ');
  m=input(' ');
end;

if m>0
zprava='';
for i=1:n/4*7
  zprava=strcat(zprava,num2str(1));
end;

celkovy_pocet_chyb=0;
pocet_bezchybnych_prenosu=0;
for j=1:m
  [prijato,pocet_opravenych_bloku,pocet_neopravenych_bloku]=...
                                      zprava_kodovana(zprava,p);
  celkovy_pocet_chyb=celkovy_pocet_chyb+pocet_neopravenych_bloku;
  if pocet_neopravenych_bloku==0
    pocet_bezchybnych_prenosu=pocet_bezchybnych_prenosu+1;
  end;
end;

disp(' ');
disp(sprintf(' Prumerny pocet chybnych bloku pri prenosu jedne zpravy je %f',...
	     celkovy_pocet_chyb/m));
disp(sprintf(' Z %d prenosu bylo %d bezchybnych,',...
             m,pocet_bezchybnych_prenosu));
disp(sprintf(' tj. %2.1f procent prenosu bylo bezchybnych.',...
             100*pocet_bezchybnych_prenosu/m));
disp(' ');
disp('-------------------------------------------------------');
pause
end;

disp(' Teoreticky plati, ze pri posilani zpravy o n bitech,    ');
disp(' s pravdepodobnosti chyby pri prenosu 1 bitu p, pricemz  ');
disp(' posilame n + 3/4 n bitu (doplnili jsme kodova slova),   ');
disp(' je pravdepodobnost bezchybneho prenosu jednoho bloku    ');
disp(' (mohla nastat nejvyse jedna chyba):                     ');
disp(' ');



pravdepodobnost_bezchybneho_prenosu_bloku=(1-p)^7+7*p*(1-p)^6;
disp('  (1-p)^7 + 7p(1-p)^6  = (1+6p)(1-p)^6  =');
disp(sprintf('    = (1+6*%f)(1-%f)^6  = %f',p,p,...
                    pravdepodobnost_bezchybneho_prenosu_bloku));
pause;

disp(' ');
disp(' Kodovych slov je posilano n/4, proto');
disp(' pravdepodobnost bezchybneho prenosu cele zpravy je    ');
disp(' ');

disp(sprintf('  ( (1+6p)(1-p)^6 )^(n/4)  = %f',...
                pravdepodobnost_bezchybneho_prenosu_bloku^(n/4)));


