function testovani_zprav_bez_uprav(n,m,p);

clc;
disp('         Testovani posilani zprav bez uprav ');
disp('-------------------------------------------------------');
if exist('n')==1 & exist('m')==1 & exist('p')==1 
 if m>0
  disp(sprintf(' Zprava o %d bitech je opakovane %d krat poslana,',n,m));
  disp(sprintf(' s pravdepodobnosti %f nastane chyba pri prenosu 1 bitu.',p));    
 end;
else
 disp(' Zprava o n bitech je opakovane m krat poslana,');
 disp(' s pravdepodobnosti p nastane chyba pri prenosu 1 bitu.');    
 disp(' ');
 fprintf(' Zadej delku zpravy     n = '); 
 n=input(' '); 
 fprintf(' Zadej pocet opakovani  m = ');
 m=input(' ');
 fprintf(' Zadej pravdepodobnost  p = ');
 p=input(' ');
end;

if m>0
zprava='';
for i=1:n
  zprava=strcat(zprava,num2str(1));
end;

celkovy_pocet_chyb=0;
pocet_bezchybnych_prenosu=0;
for j=1:m
  [prijato,pocet_chyb]=zprava_bez_uprav(zprava,p);
  celkovy_pocet_chyb=celkovy_pocet_chyb+pocet_chyb; 
  if pocet_chyb==0
    pocet_bezchybnych_prenosu=pocet_bezchybnych_prenosu+1;
  end;
end;

disp(' ');
disp(sprintf(' Prumerny pocet chyb pri prenosu jedne zpravy je %f',...
	     celkovy_pocet_chyb/m));
disp(sprintf(' Z %d prenosu bylo %d bezchybnych,',...
             m,pocet_bezchybnych_prenosu));
disp(sprintf(' tj. %2.1f procent prenosu bylo bezchybnych.',...
             100*pocet_bezchybnych_prenosu/m));
disp(' ');
disp('-------------------------------------------------------');
pause
end;

disp(' Teoreticky plati, ze pri posilani zpravy o n bitech,');
disp(' s pravdepodobnosti chyby pri prenosu 1 bitu p je    ');
disp(' pravdepodobnost bezchybneho prenosu cele zpravy:    ');
disp(' ');
disp(sprintf('  (1-p)^n = (1-%f)^%d = %f',p,n,(1-p)^n));
 
